DELIMITER $$
DROP PROCEDURE IF EXISTS V20241203123352__Create_GoogleAddressKeyConfiguration $$
CREATE PROCEDURE V20241203123352__Create_GoogleAddressKeyConfiguration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='google_address_keyconfiguration')) THEN 
CREATE TABLE IF NOT EXISTS `google_address_keyconfiguration` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
		`googleAddressKey` VARCHAR(2000) NOT NULL,
        `academyLocationId` BIGINT(20),
		`lastUpdatedBy` BIGINT(20) NOT NULL,
		`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP, 
		PRIMARY KEY (`id`),
		FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	) ENGINE=InnoDB;

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);  
    
INSERT INTO standard_master(`id`, `tableName`, `masterName`,`moduleName`,`filterCode`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (@standardMasterMaxId + 1, 'google_address_keyconfiguration', 'GOOGLE_ADDRESS_KEY_CONFIGURATION','OTHER','MASTER_WITH_AL', 0, 0, '1', NOW());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'academyLocationId', 'ACADEMY_LOCATION', @standardMasterMaxId + 1, 'number', '1', 0, 0, 1, 0, '1', NOW());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'googleAddressKey', 'GOOGLE_ADDRESS_KEY', @standardMasterMaxId + 1, 'varchar', '2', 0, 0, 1, 0, '1', NOW());


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='GOOGLE_ADDRESS_KEY_CONFIGURATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','GOOGLE_ADDRESS_KEY_CONFIGURATION','Google Address Key Configuration','Google Address Key Configuration','Google-adressleutelkonfigurasie','Cấu hình khóa địa chỉ Google',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='ACADEMY_LOCATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','ACADEMY_LOCATION','Academy Location','Academy Location','Akademie ligging','Địa điểm học viện',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='GOOGLE_ADDRESS_KEY')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','GOOGLE_ADDRESS_KEY','Google Address Key','Google Address Key','Khóa địa chỉ Google','Khóa địa chỉ Google',now(),1);
END IF;

END IF; 

END $$
CALL V20241203123352__Create_GoogleAddressKeyConfiguration () $$ 
DROP PROCEDURE IF EXISTS V20241203123352__Create_GoogleAddressKeyConfiguration $$ 
DELIMITER ;