DELIMITER $$
DROP PROCEDURE IF EXISTS V20241206132351__Create_alumniManagementPinkFloydMain $$
CREATE PROCEDURE V20241206132351__Create_alumniManagementPinkFloydMain()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_privacy_settings')) THEN
CREATE TABLE `alumni_privacy_settings` (
    id BIGINT NOT NULL AUTO_INCREMENT,
    alumniUserId BIGINT NOT NULL,
    mobileNumber BOOLEAN NOT NULL DEFAULT TRUE,
    emailId BOOLEAN NOT NULL DEFAULT TRUE,
    gender BOOLEAN NOT NULL DEFAULT TRUE,
    dateOfBirth BOOLEAN NOT NULL DEFAULT TRUE,
    officialEmailId BOOLEAN NOT NULL DEFAULT TRUE,
    officialContactNumber BOOLEAN NOT NULL DEFAULT TRUE,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
	FOREIGN KEY (alumniUserId) REFERENCES alumni_users(id)
);
END IF;


IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsRaisingGrid' and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsRaisingGrid',1,
'[{"id":null,"columnName":"IMAGE","dataIndex":"imageUrl","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"FUND_ID","dataIndex":"fundsCode","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"TITLE","dataIndex":"fundsTitle","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"DESCRIPTION","dataIndex":"description","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"START_DATE","dataIndex":"alumniStartDate","columnVisibility":"SHOW","sequence":5,"mandatory":false},
{"id":null,"columnName":"END_DATE","dataIndex":"alumniEndDate","columnVisibility":"SHOW","sequence":6,"mandatory":false},
{"id":null,"columnName":"CURRENCY","dataIndex":"currencyName","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"DONATION_GOAL","dataIndex":"donationGoal","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"STATUS","dataIndex":"status","columnVisibility":"SHOW","sequence":9,"mandatory":false}
]'
  ,now(),1);
END IF;

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsTransactionListingGrid' and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsTransactionListingGrid',1,
'[{"id":null,"columnName":"TITLE","dataIndex":"fundsTitle","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"DONATION_GOAL","dataIndex":"donationGoal","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"DONOR_NAME","dataIndex":"printName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"ALUMNI_ID","dataIndex":"alumniUserCode","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academyLocationName","columnVisibility":"SHOW","sequence":5,"mandatory":false},
{"id":null,"columnName":"RECEIVED_AMOUNT","dataIndex":"amount","columnVisibility":"SHOW","sequence":6,"mandatory":false},
{"id":null,"columnName":"RECEIVED_DATE","dataIndex":"paymentDate","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"TRANSACTION_ID","dataIndex":"transactionId","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"TRANSACTION_STATUS","dataIndex":"paymentStatus","columnVisibility":"SHOW","sequence":9,"mandatory":false}
]'
  ,now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_receipt_generation_queue')) THEN
CREATE TABLE alumni_receipt_generation_queue (
    id BIGINT NOT NULL AUTO_INCREMENT,
    completeFilePath VARCHAR(255) NOT NULL UNIQUE,
    receiptPath VARCHAR(255) NOT NULL UNIQUE,
    alumniPaymentId BIGINT DEFAULT NULL,
    userName VARCHAR(255) NOT NULL,
    emailId VARCHAR(255) NOT NULL,
    mobileNumber VARCHAR(20) DEFAULT NULL,
    receiptNumber VARCHAR(255) NOT NULL,
    donationTitle VARCHAR(255) NOT NULL,
    donationCode VARCHAR(255) NOT NULL,
    currencyCode VARCHAR(10) NOT NULL,
    paymentDate TIMESTAMP NOT NULL,
    paymentAmount DOUBLE NOT NULL,
    academyLocationName VARCHAR(255) NOT NULL,
    logoURL VARCHAR(255) DEFAULT NULL,
    currencySymbol VARCHAR(10) DEFAULT NULL,
    reportTemplateId BIGINT DEFAULT NULL,
    academyLocationId BIGINT NOT NULL,
    alumniPersonId BIGINT NOT NULL,
    addressLine1 VARCHAR(255) DEFAULT NULL,
    addressLine2 VARCHAR(255) DEFAULT NULL,
    cityName VARCHAR(255) DEFAULT NULL,
    countryRegionName VARCHAR(255) DEFAULT NULL,
    countryName VARCHAR(255) DEFAULT NULL,
    postalCode VARCHAR(20) DEFAULT NULL,
    failureReason VARCHAR(255) DEFAULT NULL,
    retryCount INT NOT NULL DEFAULT 0,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (alumniPaymentId) REFERENCES alumni_payment(id)
);
END IF; 

END $$
CALL V20241206132351__Create_alumniManagementPinkFloydMain () $$ 
DROP PROCEDURE IF EXISTS V20241206132351__Create_alumniManagementPinkFloydMain $$ 
DELIMITER ;