DELIMITER $$
DROP PROCEDURE IF EXISTS V20241206145020__Alter_AddCityPincode $$
CREATE PROCEDURE V20241206145020__Alter_AddCityPincode()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'address' 
      AND COLUMN_NAME = 'cityPinCodeId'
) THEN
    ALTER TABLE address
    ADD COLUMN cityPinCodeId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'address' 
      AND CONSTRAINT_NAME = 'FK_city_pincode'
) THEN
    ALTER TABLE address
    ADD CONSTRAINT FK_city_pincode FOREIGN KEY (cityPinCodeId) REFERENCES city_pincode(id);
END IF;


END $$
CALL V20241206145020__Alter_AddCityPincode() $$
DROP PROCEDURE IF EXISTS V20241206145020__Alter_AddCityPincode $$
DELIMITER ;