DELIMITER $$
DROP PROCEDURE IF EXISTS V20241223143416__Create_ServiceStaff $$
CREATE PROCEDURE V20241223143416__Create_ServiceStaff()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='service_staff')) THEN 
CREATE TABLE service_staff(
 id BIGINT NOT NULL AUTO_INCREMENT,
 serviceId BIGINT NOT NULL,
 coordinatorId BIGINT NOT NULL,
 lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 lastUpdatedBy BIGINT DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_service_staff_serviceId` FOREIGN KEY (`serviceId`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_service_staff_coordinatorId` FOREIGN KEY (`coordinatorId`) REFERENCES `staffs` (`userId`)
);
END IF; 

END $$
CALL V20241223143416__Create_ServiceStaff () $$ 
DROP PROCEDURE IF EXISTS V20241223143416__Create_ServiceStaff $$ 
DELIMITER ;