CREATE OR REPLACE  VIEW `analytics_alumni_donation_view` AS
SELECT DISTINCT `ap`.`alumniUserId` AS `Alumni_user_primary_id`,`ap`.`alumniFundsId` AS `Alumni_funds_primary_id`,`ap`.`currencyId` AS `Currency_primary_id`, CONCAT(IFNULL(`per`.`firstName`,''),' ', IFNULL(`per`.`middleName`,''),' ', IFNULL(`per`.`lastName`,'')) AS `fullName`,`u`.`alumniCode` AS `Alumni Code`,`ap`.`amount` AS `Payment Amount`,`ap`.`paymentDate` AS `Payment Date`,`ap`.`paymentEnitiateDate` AS `Payment Enitiate Date`,`ap`.`paymentGateway` AS `Payment Gateway`,`ap`.`transactionId` AS `Transaction ID`,`ap`.`paymentStatus` AS `Payment Status`,`ap`.`receiptCode` AS `Receipt Code`,`af`.`fundsCode` AS `Fund Code`,`af`.`fundsTitle` AS `alumni_funds`,`af`.`donationGoal` AS `Donation Goal`,`af`.`startDate` AS `Fund Start Date`,`af`.`endDate` AS `Fund End Date`,`af`.`status` AS `Fund Status`,`af`.`description` AS `Fund Description`,`af`.`whetherDeleted` AS `Fund_whether_deleted`,`af`.`fundsTitle` AS `Fund_title`,`adr`.`minimumValue` AS `Minimum Fund Range`,`adr`.`maximumValue` AS `Maximum Fund Range`,`al`.`displayName` AS `Academy Location Name`,`al`.`academyCode` AS `Academy Code`,`ap`.`id` AS `Alumni_payment_primary_id`,`per`.`passoutYear` AS `Passout Year`,`per`.`status` AS `Alumni Status`, YEAR(`ap`.`paymentDate`) AS `Payment Year`,`al`.`locationCode` AS `Location Code`
FROM ((((((`alumni_payment` `ap`
LEFT JOIN `alumni_funds` `af` ON((`af`.`id` = `ap`.`alumniFundsId`)))
LEFT JOIN `alumni_donation_range` `adr` ON(((`adr`.`alumniFundsId` = `af`.`id`) AND (`adr`.`id` = `ap`.`alumniDonationRangeId`))))
LEFT JOIN `alumni_funds_academy_location_mapping` `afal` ON((`afal`.`alumniFundsId` = `af`.`id`)))
LEFT JOIN `alumni_users` `u` ON((`u`.`id` = `ap`.`alumniUserId`)))
LEFT JOIN `alumni_persons` `per` ON((`per`.`alumniUserId` = `u`.`id`)))
LEFT JOIN `academy_location` `al` ON((`per`.`academyLocationId` = `al`.`id`))) ;