DELIMITER $$
DROP PROCEDURE IF EXISTS V20241227153254__Update_updateStudCouEnrolInfoForInactive $$
CREATE PROCEDURE V20241227153254__Update_updateStudCouEnrolInfoForInactive()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataProviderId=(select id from dydt_data_provider where providerName='Inactive Admission Data Providers') and dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO')) THEN 
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
    c.courseName AS COURSE_NAME, 
    FLOOR ( c.courseCredits) AS COURSE_CREDITS,
    lp.topics AS TEACHING_HOURS,
    lp.term AS LEARNING_HOURS 
    from student_course_enrollment sce
    inner join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
    inner join admission adm on adm.id=sce.admissionId
    inner join course_variants cv on cv.id=sce.courseVarientId
    INNER JOIN sections ss on ss.id = sce.sectionId
     left join courses c on c.id=cv.courseId  
     left join lesson_plan lp on lp.courseId=cv.courseId and pbpc.academicTermId=lp.academicTermId ',
    `resultColumnsDef` = 'COURSE_NAME, COURSE_CREDITS, TEACHING_HOURS, LEARNING_HOURS',
    `sqlWhereQueryDef` = 'where adm.id=PRM_ADMISSION_ID and sce.programBatchPeriodConfigId>=(
     CASE 
            WHEN adm.activeStatus=true
                THEN
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and 
    pbs.exitDate is null)
                ELSE
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID order by id DESC limit 1 )
                END
    ) and sce.exitDate is null group by sce.courseVarientId union all
    SELECT 
    "Total" AS TOTAL, 
    COALESCE(SUM(COALESCE(c.courseCredits, 0)), 0) AS COURSE_CREDITS_TOTAL,
    COALESCE(SUM(COALESCE(lp.topics, 0)), 0) AS TEACHING_HOURS_TOTAL,
    COALESCE(SUM(COALESCE(lp.term, 0)), 0) AS LEARNING_HOURS_TOTAL  
    from student_course_enrollment sce
    inner join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
    inner join admission adm on adm.id=sce.admissionId
    inner join course_variants cv on cv.id=sce.courseVarientId
    INNER JOIN sections ss on ss.id = sce.sectionId
     left join courses c on c.id=cv.courseId  
     left join lesson_plan lp on lp.courseId=cv.courseId and pbpc.academicTermId=lp.academicTermId where adm.id=PRM_ADMISSION_ID and sce.programBatchPeriodConfigId>=(
     CASE 
            WHEN adm.activeStatus=true
                THEN
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and 
    pbs.exitDate is null)
                ELSE
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID order by id DESC limit 1 )
                END
    ) and sce.exitDate is null '
WHERE dataProviderId=(select id from dydt_data_provider where providerName='Inactive Admission Data Providers') and dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO';

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241227153254__Update_updateStudCouEnrolInfoForInactive () $$
DROP PROCEDURE IF EXISTS V20241227153254__Update_updateStudCouEnrolInfoForInactive $$
DELIMITER ;