DELIMITER $$
DROP PROCEDURE IF EXISTS V20241230142831__Create_Program_fee_refundrule_bill $$
CREATE PROCEDURE V20241230142831__Create_Program_fee_refundrule_bill()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_fee_refundrule_bills' )) THEN 
CREATE TABLE program_fee_refundrule_bills (
id bigint(20) NOT NULL AUTO_INCREMENT,
pbsId bigint(20) DEFAULT NULL,
admissionId bigint(20) DEFAULT NULL,
studentId bigint(20) DEFAULT NULL,
programBillId bigint(20) DEFAULT NULL,
refundBillId bigint(20) DEFAULT NULL,
refundBillCategory varchar(30) DEFAULT NULL,
transactionType varchar(30) DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

PRIMARY KEY (id),
CONSTRAINT `fk_pbs_pfrb` FOREIGN KEY (pbsId) REFERENCES program_batch_students (id),
CONSTRAINT `fk_prog_bill_id_pfrb` FOREIGN KEY (programBillId) REFERENCES bill_header (id),
CONSTRAINT `fk_refund_bill_id_pfrb` FOREIGN KEY (refundBillId) REFERENCES bill_header (id),
CONSTRAINT `fk_admission_id_pfrb` FOREIGN KEY (admissionId) REFERENCES admission (id),
CONSTRAINT `fk_student_id_pfrb` FOREIGN KEY (studentId) REFERENCES students (userId),
CONSTRAINT `fk_user_id_pfrb` FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);
END IF; 

END $$
CALL V20241230142831__Create_Program_fee_refundrule_bill () $$ 
DROP PROCEDURE IF EXISTS V20241230142831__Create_Program_fee_refundrule_bill $$ 
DELIMITER ;