DELIMITER $$
DROP PROCEDURE IF EXISTS V20250122161835__Create_GeneralEducationCategoryTable $$
CREATE PROCEDURE V20250122161835__Create_GeneralEducationCategoryTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='general_education_category_csm')) THEN 
CREATE TABLE `general_education_category_csm` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(100) NOT NULL,
  `name` VARCHAR(500) NOT NULL,
  `status` varchar(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `code` (`code` ASC),
  UNIQUE INDEX `name` (`name` ASC),
  INDEX `fk_general_education_category_csm_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_general_education_category_csm_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20250122161835__Create_GeneralEducationCategoryTable () $$ 
DROP PROCEDURE IF EXISTS V20250122161835__Create_GeneralEducationCategoryTable $$ 
DELIMITER ;