DELIMITER $$
DROP PROCEDURE IF EXISTS V20250122161933__Create_GeneralEducationCategoryCSM $$
CREATE PROCEDURE V20250122161933__Create_GeneralEducationCategoryCSM()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'GENERAL_EDUCATION_CATEGORY')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'general_education_category_csm','GENERAL_EDUCATION_CATEGORY','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'CODE')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'CODE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '100', '1', now());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'NAME')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'name', 'NAME', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '500', '1', now());
END IF; 

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'STATUS')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'status', 'STATUS', @standardMasterMaxId+1, 'Enum','DUBLIN_DESCRIPTORS_ACTIVE_INACTIVE','3',false, 0, 0, 0, '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'GENERAL_EDUCATION_CATEGORY')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'GENERAL_EDUCATION_CATEGORY', 'General Education Category', 'General Education Category','Algemene Onderwyskategorie','Hạng mục giáo dục phổ thông',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'CODE')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'CODE', 'Code', 'Code','Kode','Mã số',now(),1);
	END IF; 
	
	
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'NAME')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'NAME', 'Name', 'Name','Naam','Tên',now(),1);
	END IF; 

END $$
CALL V20250122161933__Create_GeneralEducationCategoryCSM () $$ 
DROP PROCEDURE IF EXISTS V20250122161933__Create_GeneralEducationCategoryCSM $$ 
DELIMITER ;