DELIMITER $$
DROP PROCEDURE IF EXISTS V20250318151315__Alter_xeroContact $$
CREATE PROCEDURE V20250318151315__Alter_xeroContact()
BEGIN
-- Drop foreign key if it exists
IF EXISTS (SELECT * FROM information_schema.KEY_COLUMN_USAGE 
           WHERE TABLE_SCHEMA = DATABASE() 
           AND TABLE_NAME = 'xero_user_mapping' 
           AND CONSTRAINT_NAME = 'fk_xero_user_mapping_academiaUserId') 
THEN 
    ALTER TABLE `xero_user_mapping` 
    DROP FOREIGN KEY `fk_xero_user_mapping_academiaUserId`;
END IF;

-- Add columns if they do not exist
IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping' 
               AND COLUMN_NAME = 'academiaApplicationId') 
THEN
    ALTER TABLE `xero_user_mapping` 
    ADD COLUMN `academiaApplicationId` BIGINT NULL AFTER `academiaUserId`;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping' 
               AND COLUMN_NAME = 'academiaSponsorId') 
THEN
    ALTER TABLE `xero_user_mapping` 
    ADD COLUMN `academiaSponsorId` BIGINT NULL AFTER `academiaApplicationId`;
END IF;

-- Modify column if it exists
IF EXISTS (SELECT * FROM information_schema.COLUMNS 
           WHERE TABLE_SCHEMA = DATABASE() 
           AND TABLE_NAME = 'xero_user_mapping' 
           AND COLUMN_NAME = 'academiaUserId') 
THEN
    ALTER TABLE `xero_user_mapping` 
    CHANGE COLUMN `academiaUserId` `academiaUserId` BIGINT NULL;
END IF;

-- Add indexes if they do not exist
IF NOT EXISTS (SELECT * FROM information_schema.STATISTICS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping' 
               AND INDEX_NAME = 'fk_xero_user_mapping_academiaSponsorId_idx') 
THEN
    ALTER TABLE `xero_user_mapping` 
    ADD INDEX `fk_xero_user_mapping_academiaSponsorId_idx` (`academiaSponsorId` ASC) ;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.STATISTICS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping' 
               AND INDEX_NAME = 'fk_xero_user_mapping_academiaApplicationId_idx') 
THEN
    ALTER TABLE `xero_user_mapping` 
    ADD INDEX `fk_xero_user_mapping_academiaApplicationId_idx` (`academiaApplicationId` ASC) ;
END IF;

-- Add foreign key constraints if they do not exist
IF NOT EXISTS (SELECT * FROM information_schema.REFERENTIAL_CONSTRAINTS 
               WHERE CONSTRAINT_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping' 
               AND CONSTRAINT_NAME = 'fk_xero_user_mapping_academiaUserId') 
THEN
    ALTER TABLE `xero_user_mapping` 
    ADD CONSTRAINT `fk_xero_user_mapping_academiaUserId`
      FOREIGN KEY (`academiaUserId`)
      REFERENCES `users` (`id`);
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.REFERENTIAL_CONSTRAINTS 
               WHERE CONSTRAINT_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping' 
               AND CONSTRAINT_NAME = 'fk_xero_user_mapping_academiaSponsorId') 
THEN
    ALTER TABLE `xero_user_mapping` 
    ADD CONSTRAINT `fk_xero_user_mapping_academiaSponsorId`
      FOREIGN KEY (`academiaSponsorId`)
      REFERENCES `sponsors` (`id`);
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.REFERENTIAL_CONSTRAINTS 
               WHERE CONSTRAINT_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping' 
               AND CONSTRAINT_NAME = 'fk_xero_user_mapping_academiaApplicationId') 
THEN
    ALTER TABLE `xero_user_mapping` 
    ADD CONSTRAINT `fk_xero_user_mapping_academiaApplicationId`
      FOREIGN KEY (`academiaApplicationId`)
      REFERENCES `application` (`id`);
END IF;

END $$
CALL V20250318151315__Alter_xeroContact() $$
DROP PROCEDURE IF EXISTS V20250318151315__Alter_xeroContact $$
DELIMITER ;