DELIMITER $$
DROP PROCEDURE IF EXISTS fatchApplicantToBePushInXero $$
CREATE PROCEDURE fatchApplicantToBePushInXero(jobLastRunTimestamp timestamp)
BEGIN
SELECT
    func_inc_var_session_rec() AS id,
    app.id as userId,
    app.code as userCode,
    null as status,
    appPerson.printName as userName,
    appPerson.firstName as firstName,
    appPerson.lastName as lastName,
    appPerson.shortName as shortName,
    appPerson.emailId as email,
    appPerson.mobileNumber as mobileNumber,
    appPerson.mobileCountryCode as mobileCountryCode,
    appProgram.academyLocationId as locationId,
    userMapping.xeroContactId as xeroContactId,
    'APPLICANT' as role
FROM
    application AS app
		JOIN
    applicant_person AS appPerson ON appPerson.id = app.applicantPersonId
		JOIN 
	application_program as appProgram ON appProgram.applicationId=app.id
       left JOIN
	xero_user_mapping as userMapping ON (userMapping.academiaApplicationId=app.id and userMapping.academyLocationId=appProgram.academyLocationId)
    where userMapping.id is null 
    group by locationId , userId
    UNION ALL SELECT 
	func_inc_var_session_rec() AS id,
    app.id as userId,
    app.code as userCode,
    null as status,
    appPerson.printName as userName,
    appPerson.firstName as firstName,
    appPerson.lastName as lastName,
    appPerson.shortName as shortName,
    appPerson.emailId as email,
    appPerson.mobileNumber as mobileNumber,
    appPerson.mobileCountryCode as mobileCountryCode,
    appProgram.academyLocationId as locationId,
    userMapping.xeroContactId as xeroContactId,
    'APPLICANT' as role
   FROM
    application AS app
		JOIN
    applicant_person AS appPerson ON appPerson.id = app.applicantPersonId
		JOIN 
	application_program as appProgram ON appProgram.applicationId=app.id
        JOIN
	xero_user_mapping as userMapping ON (userMapping.academiaApplicationId=app.id and userMapping.academyLocationId=appProgram.academyLocationId)
    where app.lastUpdate > jobLastRunTimestamp 
    group by locationId , userId;
END $$ 
DELIMITER ;