DELIMITER $$
DROP PROCEDURE IF EXISTS V20250402173834__Update_QRScannerPushNotificationForCourse $$
CREATE PROCEDURE V20250402173834__Update_QRScannerPushNotificationForCourse()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_DL')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_DL');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
    T3.id AS USER_ID  
FROM
    student_course_attendance sca
            JOIN
        student_course_enrollment sce ON sce.sectionId = sca.sectionId
            AND sce.courseVarientId = sca.variantId
            JOIN
        admission AS T2 ON T2.id = sce.admissionId
            JOIN
        users AS T3 ON T3.id = T2.studentId
        join fire_base_persons_info f on f.userId=T3.id
    WHERE
        sca.id IN (namedParams)
            AND sce.exitDate IS NULL
            AND sce.isCurrentSection = TRUE
            AND DATE(sce.enrollmentDate) <= DATE(sca.dateOfAttendance)
            AND T2.activeStatus = TRUE
            AND NOT EXISTS( SELECT 
                1
            FROM
                student_apply_hold_category H
            WHERE
                H.studentId = T3.id)
    GROUP BY T3.id'
WHERE
    (`dataProviderId` = @dtproviderId);
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_RCPNT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_COURSE_WISE_RCPNT');   
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
    f.userId AS ID,
    group_concat(distinct f.deviceTokenId) AS DEVICE_ID,
	\'QR_SCANNER\' AS MSG_CATEGORY
FROM
    fire_base_persons_info f 
WHERE
    f.userId IN (namedParams)',
    `jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        }
    ]
}'
WHERE
    (`dataProviderId` = @dtproviderId);

END IF;  
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250402173834__Update_QRScannerPushNotificationForCourse () $$
DROP PROCEDURE IF EXISTS V20250402173834__Update_QRScannerPushNotificationForCourse $$
DELIMITER ;