DELIMITER $$
DROP PROCEDURE IF EXISTS V20250428172313__Insert_InitiatorCourseInterestEvent $$
CREATE PROCEDURE V20250428172313__Insert_InitiatorCourseInterestEvent()
BEGIN

 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='EMPLOYEE');
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'INITIATOR_INITIATE_THE_INTEREST');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='INITIATOR_INITIATE_THE_INTEREST');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'INITIATOR_COURSE_INTEREST', 'Initiator Course Interest', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Initiator Course Interest', 'Initiator Course Interest');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'INITIATOR_COURSE_INTEREST_DL', 'SQL');

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'INITIATOR_COURSE_INTEREST_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INITIATOR_COURSE_INTEREST_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`,`idParamName`) VALUES (@msgRecipientId+1, @dtproviderId, 'INITIATOR_COURSE_INTEREST_RCPNT','CONTEXT_RECORD_ID');


-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INITIATOR_COURSE_INTEREST_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='INITIATOR_COURSE_INTEREST_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list
SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INITIATOR_COURSE_INTEREST_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select distinct T1.id AS USER_ID 
from faculty_course_interest_msg T1 where T1.facultyCourseInterestId in(namedParams)",NULL); 

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INITIATOR_COURSE_INTEREST_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select T1.id AS ID,
T9.firstName AS FIRST_NAME,
T9.lastName AS LAST_NAME,
T9.emailId AS EMAIL_ID,
T11.mobileNumber AS MOBILE_NO,
T13.code AS INITIATOR_CODE,
T13.printName AS INITIATOR_NAME,
T15.code AS EMPLOYEE_CODE,
T15.printName AS EMPLOYEE_NAME,
T4.courseCode AS COURSE_CODE,
T4.courseName AS COURSE_NAME,
T12.componentType AS COMPONENTS,
T6.courseCESMValue AS COURSE_CESM,
T7.itemValue AS PROGRAM_CESM
 from  faculty_course_interest_msg T1 
 join courses T4 on T4.id=T1.courseId
 join course_components T5 on T5.id=T1.courseComponentId
 join course_cesm_code T6 on T6.id=T1.courseCESMCodeId
 join program_cesm T7 on T7.id=T1.programCESMCodeId
 join faculty_course_interest T8 on T8.id=T1.facultyCourseInterestId
join users T9 on T9.id=T1.approverId
 Join staffs T10 on T10.userId=T9.id
  join persons T11 on T11.id=T10.personId
  join component_type T12 on T12.id=T5.componentTypeId
  left join users T13 on T13.id=T1.initiatorIdId
  left join staffs T14 on T14.userId=T8.facultyId
 left join users T15 on T15.id=T14.userId
where T9.emailId is not null and T1.id in (namedParams)",
'{
 "id": 1,
     "searchResultViewColumns": [
      {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },       
        {
            "id": 6,
            "value": "code",
            "resultKey": "INITIATOR_CODE",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "printName",
            "resultKey": "INITIATOR_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "code",
            "resultKey": "EMPLOYEE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "printName",
            "resultKey": "EMPLOYEE_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "courseCode",
            "resultKey": "COURSE_CODE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "courseName",
            "resultKey": "COURSE_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
         {
            "id": 12,
            "value": "componentType",
            "resultKey": "COMPONENTS",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "courseCESMValue",
            "resultKey": "COURSE_CESM",
            "displayCode": "",
            "displayOrder": 12
        },
         {
            "id": 14,
            "value": "itemValue",
            "resultKey": "PROGRAM_CESM",
            "displayCode": "",
            "displayOrder": 13
        }
    ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='INITIATOR_COURSE_INTEREST');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='INITIATOR_INITIATE_THE_INTEREST');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='INITIATOR_COURSE_INTEREST_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Initiator Course Interest',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Initiator Course Interest',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English',1);

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Initiator Course Interest','<html>
<head>
	<title></title>
</head>
<body bgcolor="silver">
<p>The following academic approval request has been submitted for your approval:
Initiator: $recipientData[&quot;INITIATOR_NAME&quot;] (Initiator ID: $recipientData[&quot;INITIATOR_CODE&quot;]) <br>
Employee Name: $recipientData[&quot;EMPLOYEE_NAME&quot;] Employee ID($recipientData[&quot;EMPLOYEE_CODE&quot;]) <br>
has expressed interest in the ($recipientData[&quot;COMPONENTS&quot;]) of ($recipientData[&quot;COURSE_CODE&quot;]/$recipientData[&quot;COURSE_NAME&quot;]), <br>
under Course CESM Code: ($recipientData[&quot;COURSE_CESM&quot;]) and Program CESM Code: ($recipientData[&quot;PROGRAM_CESM&quot;]).</p>

</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','Initiator Course Interest',
'<html>
<head>
	<title></title>
</head>
<body bgcolor="silver">
<p>The following academic approval request has been submitted for your approval:
Initiator: $recipientData[&quot;INITIATOR_NAME&quot;] (Initiator ID: $recipientData[&quot;INITIATOR_CODE&quot;]) <br>
Employee Name: $recipientData[&quot;EMPLOYEE_NAME&quot;] Employee ID($recipientData[&quot;EMPLOYEE_CODE&quot;]) <br>
has expressed interest in the ($recipientData[&quot;COMPONENTS&quot;]) of ($recipientData[&quot;COURSE_CODE&quot;]/$recipientData[&quot;COURSE_NAME&quot;]), <br>
under Course CESM Code: ($recipientData[&quot;COURSE_CESM&quot;]) and Program CESM Code: ($recipientData[&quot;PROGRAM_CESM&quot;]).</p>

</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Initiator Course Interest',
'<html>
<head>
	<title></title>
</head>
<body bgcolor="silver">
<p>The following academic approval request has been submitted for your approval:
Initiator: $recipientData[&quot;INITIATOR_NAME&quot;] (Initiator ID: $recipientData[&quot;INITIATOR_CODE&quot;]) <br>
Employee Name: $recipientData[&quot;EMPLOYEE_NAME&quot;] Employee ID($recipientData[&quot;EMPLOYEE_CODE&quot;]) <br>
has expressed interest in the ($recipientData[&quot;COMPONENTS&quot;]) of ($recipientData[&quot;COURSE_CODE&quot;]/$recipientData[&quot;COURSE_NAME&quot;]), <br>
under Course CESM Code: ($recipientData[&quot;COURSE_CESM&quot;]) and Program CESM Code: ($recipientData[&quot;PROGRAM_CESM&quot;]).</p>

</body>
</html>');
 
 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INITIATOR_COURSE_INTEREST')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INITIATOR_COURSE_INTEREST', 'Initiator Course Interest', 'Initiator Course Interest', 'Inisieerder Kursus Belangstelling', 'Sở thích của khóa học khởi tạo',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INITIATOR_INITIATE_THE_INTEREST')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INITIATOR_INITIATE_THE_INTEREST', 'Initiator Initiate the Interest', 'Initiator Initiate the Interest', 'Inisieerder Inisieer die belangstelling', 'Người khởi xướng khởi xướng sự quan tâm',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INITIATOR_COURSE_INTEREST_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INITIATOR_COURSE_INTEREST_DL', 'Initiator Course Interest DL', 'Initiator Course Interest DL', 'Inisieerder Kursus Belangstelling DL', 'Khóa học khởi tạo quan tâm DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INITIATOR_COURSE_INTEREST_RCPNT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INITIATOR_COURSE_INTEREST_RCPNT', 'Initiator Course Interest Recipient', 'Initiator Course Interest Recipient', 'Inisieerder Kursus Belangstelling Ontvanger', 'Người nhận quan tâm đến khóa học khởi tạo',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='INITIATOR_COURSE_INTEREST')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('INITIATOR_COURSE_INTEREST', 'Initiator Course Interest');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='INITIATOR_COURSE_INTEREST_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('INITIATOR_COURSE_INTEREST_DL', 'Initiator Course Interest DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='INITIATOR_COURSE_INTEREST_RCPNT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('INITIATOR_COURSE_INTEREST_RCPNT', 'Initiator Course Interest Recipient');
END IF;
 
 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INITIATOR_CODE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INITIATOR_CODE', 'Initiator Code', 'Initiator Code', 'Inisieerder Kode', 'Mã khởi tạo',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INITIATOR_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INITIATOR_NAME', 'Initiator Name', 'Initiator Name', 'Inisieerder Naam', 'Tên người khởi xướng',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EMPLOYEE_CODE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EMPLOYEE_CODE', 'Employee Code', 'Employee Code', 'Werknemer Kode', 'Mã nhân viên',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EMPLOYEE_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EMPLOYEE_NAME', 'Employee Name', 'Employee Name','Werknemer Naam', 'Tên nhân viên',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='COMPONENTS')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'COMPONENTS', 'Component', 'Component', 'Komponent', 'Thành phần',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='COURSE_CESM')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'COURSE_CESM', 'Course Cesm', 'Course Cesm', 'Kursus Cesm', 'Khóa học Cesm',now(),1);
END IF;

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROGRAM_CESM')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROGRAM_CESM', 'Program Cesm', 'Program Cesm', 'Program Cesm', 'Chương trình Cesm',now(),1);
END IF;

END $$

CALL V20250428172313__Insert_InitiatorCourseInterestEvent() $$
DROP PROCEDURE IF EXISTS V20250428172313__Insert_InitiatorCourseInterestEvent $$
DELIMITER ;