DELIMITER $$
DROP PROCEDURE IF EXISTS V20250514181304__Insert_ProgramInitiativeMapping $$
CREATE PROCEDURE V20250514181304__Insert_ProgramInitiativeMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.tables    WHERE table_schema = DATABASE() AND table_name = 'program_initiative_mapping')) THEN 
CREATE TABLE `program_initiative_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `programSpecificInitiativeId` BIGINT NOT NULL,
  `programId`  BIGINT NOT NULL,
  `startDate` DATE DEFAULT NULL,
  `endDate` DATE  DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_program_initiative_mapping_programSpecificInitiativeId_idx` (`programSpecificInitiativeId` ASC),
  INDEX `fk_program_initiative_mapping_programId_idx` (`programId` ASC),
  INDEX `fk_program_initiative_mapping_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
 

  CONSTRAINT `fk_program_initiative_mapping_programSpecificInitiativeId`
    FOREIGN KEY (`programSpecificInitiativeId`)
    REFERENCES `program_specific_initiative` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

CONSTRAINT `fk_program_initiative_mapping_programId`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
  CONSTRAINT `fk_program_initiative_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION
    
) ;

END IF;

END $$
CALL V20250514181304__Insert_ProgramInitiativeMapping() $$
DROP PROCEDURE IF EXISTS V20250514181304__Insert_ProgramInitiativeMapping $$
DELIMITER ;