DELIMITER $$
DROP PROCEDURE IF EXISTS getHESAQualificationData $$
CREATE PROCEDURE getHESAQualificationData(IN programId BIGINT)
BEGIN
SELECT 
    p.id AS pid,
    pc.categoryName AS QUALCAT,
    p.programCode AS QUALID,
    p.programName AS QUALTITLE,
    hq.itemCode AS AWARDINGBODYID,
    qs.itemCode AS QUALITT,
    pqm.programRoleProportion AS QUALPROPORTION,
    hs.itemCode AS QUALSUBJECT
FROM
    programs p
    LEFT JOIN program_category pc ON p.programCategoryId = pc.id
    LEFT JOIN heqf_level hq ON p.heqfLevelId = hq.id
    LEFT JOIN program_qualification_mapping pqm ON p.id = pqm.programId
    LEFT JOIN qualification_specialism qs ON pqm.qualificationIttSpecialismId = qs.id
    LEFT JOIN hesa_subject hs ON pqm.hesaSubjectId = hs.id
WHERE
    p.id IN (programId);

END $$
DELIMITER ;