DELIMITER $$
DROP PROCEDURE IF EXISTS V20250611090116__Alter_AddColumnApplicantPers $$
CREATE PROCEDURE V20250611090116__Alter_AddColumnApplicantPers()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='intakeYearId')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `intakeYearId` BIGINT(30)  DEFAULT NULL after studentNoAtOtherSAU;
END IF; 

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_person_intakeYearId' AND table_name='persons') then
ALTER TABLE `persons` ADD CONSTRAINT `fk_person_intakeYearId`
  FOREIGN KEY (`intakeYearId`)
  REFERENCES `intake_year` (id)
  ON DELETE RESTRICT;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='intakeYearId')) THEN 
ALTER TABLE `applicant_person` 
ADD COLUMN `intakeYearId` BIGINT(30)  DEFAULT NULL after studentNoAtOtherSAU;

END IF; 

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_applicant_person_intakeYearId' AND table_name='applicant_person') then
ALTER TABLE `applicant_person` ADD CONSTRAINT `fk_applicant_person_intakeYearId`
  FOREIGN KEY (`intakeYearId`)
  REFERENCES `intake_year` (id)
  ON DELETE RESTRICT;
END IF;

END $$
CALL V20250611090116__Alter_AddColumnApplicantPers() $$
DROP PROCEDURE IF EXISTS V20250611090116__Alter_AddColumnApplicantPers $$
DELIMITER ;