DELIMITER $$
DROP PROCEDURE IF EXISTS getHESAStudentPhaseTwo $$
CREATE PROCEDURE getHESAStudentPhaseTwo(IN programId BIGINT, IN academicTermId BIGINT)
BEGIN

    SELECT DISTINCT
	 ad.Code As ADMISSIONCODE,
	 pbpc.programPeriodName AS SCSESSIONID,
	 pg.programCode AS COURSEID,
	 mody.itemCode AS SCSMODE,
	 pbpc.programPeriodStart AS SCSSTARTDATE,
     uoa.itemCode AS REF2021UNITOFASSESSMENT, 
     tab.itemCode AS SUPALLHESAID ,
     stt.supervisorIdentifier AS SUPALLID ,
     stt.supervisorProportion AS SUPALLPROP,
     apf.itemCode AS APPSPEND,
     fs.financialSupportAmount AS FINSUPAMOUNT,
     fst.itemCode AS FINSUPTYPE,
     dd.name AS STUINITID
     from
    program_batch_students pbs 
    LEFT JOIN prog_batch_period_config pbpc on pbs.progBatchPeriodConfigId=pbpc.id
    LEFT JOIN batches bs on pbpc.programBatchId=bs.id
    LEFT JOIN programs pg on bs.programId=pg.id
    LEFT JOIN mode_of_delivery mody ON bs.modeOfDeliveryId = mody.id
    LEFT JOIN academic_term ats on pbpc.academicTermId=ats.id
    LEFT JOIN admission ad on pbs.admissionId-ad.id
    LEFT JOIN students st on ad.studentId=st.userId
    LEFT JOIN persons ps on st.personId=ps.id
    LEFT JOIN student_thesis_title stt on pg.id=stt.programId and st.personId=stt.personId
    LEFT JOIN unit_of_assessment uoa on stt.unitOfAssessmentId=uoa.id
    LEFT JOIN thesis_approval_body tab on stt.approvalBody=tab.id
    LEFT JOIN financial_support fs on pg.id= fs.programId and st.userId=fs.studentId
    LEFT JOIN access_and_participation_flag apf on fs.accessAndParticipantFlagId=apf.id
    LEFT JOIN financial_support_type fst on fs.financialSupportTypeId=fst.id
    LEFT JOIN drop_down dd on ps.fieldOfInterest=dd.id and dd.type='fieldOfInterest'
    WHERE pbpc.academicTermId = academicTermId 
    AND pg.id = programId 
    And pbs.isCurrentPeriod = 1 AND pbs.isCurrentSection = 1 AND pbs.exitDate IS NULL AND ad.activeStatus is true
    GROUP BY ad.id,pg.id;

END $$ 
DELIMITER ;