DELIMITER $$

DROP PROCEDURE IF EXISTS V20250722171353__Alter_dataProviderHostelUnAlltStudent $$

CREATE PROCEDURE V20250722171353__Alter_dataProviderHostelUnAlltStudent()
BEGIN

IF EXISTS (SELECT id FROM dtprovider WHERE dataProviderName = 'HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT') THEN 
    SET sql_safe_updates = 0;

    SET @dtproviderid = (SELECT id FROM dtprovider WHERE dataProviderName = 'HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT');

    -- Update SQL Query
    UPDATE sql_dtprovider 
    SET sqlQuery = 'SELECT DISTINCT
        T1.id AS ID,
        T5.code AS HOSTEL_STUDENT_ID,
        T6.firstName AS FIRST_NAME,
        T6.middleName AS MIDDLE_NAME,
        T6.lastName AS LAST_NAME,
        T6.printName AS PRINT_NAME,
        T6.emailId AS EMAIL_ID,
        T6.firstName AS HOSTEL_STUDENT_FIRST_NAME,
        T6.middleName AS HOSTEL_STUDENT_MIDDLE_NAME,
        T6.lastName AS HOSTEL_STUDENT_LAST_NAME,
        T6.printName AS HOSTEL_STUDENT_PRINT_NAME,
        T6.externalSysRefOne AS HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE,
        T9.salutationName AS HOSTEL_TITLE,
        T6.initials AS HOSTEL_INITIAL,
        T8.itemValue AS HOSTEL_ACADEMIC_TERM,
        T10.code AS HOSTEL_ID,
        T10.resourceName AS HOSTEL_NAME,
        T10.resourceNameOtherLanguage AS HOSTEL_NAME_OTHER_LANGUAGE,
        T13.locationName AS HOSTEL_LOCATION,
        T1.unAllocationDate AS UNALLOCATED_DATE,
        T15.printName AS CANCELLATION_BY,
        T1.unAllocationDate AS CANCEL_DATE,
        ml.code as LANGUAGE_KEY,
        (SELECT GROUP_CONCAT(DISTINCT deviceTokenId)
         FROM fire_base_persons_info
         WHERE fire_base_persons_info.userId = T5.id) AS DEVICE_ID,
        T6.mobileCountryCode as MOBILE_CODE,
        T6.mobileNumber as MOBILE_NO
    FROM student_hostel_application T1
        LEFT OUTER JOIN hostel_application_setup T2 ON T2.id = T1.hostelApplicationSetupId
        LEFT OUTER JOIN academic_term T3 ON T3.id = T2.year
        LEFT OUTER JOIN students T4 ON T4.userId = T1.studentId
        LEFT OUTER JOIN users T5 ON T5.id = T4.userId
        LEFT OUTER JOIN persons T6 ON T6.id = T4.personId
        LEFT OUTER JOIN academic_term T8 ON T8.id = T1.hostelApplicationYearId
        LEFT OUTER JOIN salutations T9 ON T9.id = T6.salutationId
        LEFT OUTER JOIN resources T10 ON T10.id = T1.unAllocatedHostelId
        LEFT OUTER JOIN resource_academy_locations T11 ON T11.resourceId = T1.unAllocatedHostelId AND T11.whetherPrimary = TRUE
        LEFT OUTER JOIN academy_location T12 ON T12.id = T11.academyLocationId
        LEFT OUTER JOIN locations T13 ON T13.id = T12.locationId
        LEFT OUTER JOIN multi_language ml ON ml.id = T6.correspondence_language
        LEFT OUTER JOIN users T15 ON T15.id = T1.lastUpdatedBy
    WHERE T1.id IN (namedParams)'
    WHERE dataProviderId = @dtproviderid;

    UPDATE sql_dtprovider
    SET jsonString = '{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "printName",
            "resultKey": "HOSTEL_STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "HOSTEL_STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "HOSTEL_STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "HOSTEL_STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "code",
            "resultKey": "HOSTEL_STUDENT_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "externalSysRefOne",
            "resultKey": "HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "salutationName",
            "resultKey": "HOSTEL_TITLE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "initials",
            "resultKey": "HOSTEL_INITIAL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "locationName",
            "resultKey": "HOSTEL_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "code",
            "resultKey": "HOSTEL_ID",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "resourceName",
            "resultKey": "HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "itemValue",
            "resultKey": "HOSTEL_ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "unAllocationDate",
            "resultKey": "UNALLOCATED_DATE",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "hostelNameOtherLanguage",
            "resultKey": "HOSTEL_NAME_OTHER_LANGUAGE",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "cancellationBy",
            "resultKey": "CANCELLATION_BY",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "cancelDate",
            "resultKey": "CANCEL_DATE",
            "displayCode": "",
            "displayOrder": 16
        }
    ]
 }'
    WHERE dataProviderId = @dtproviderid;

    SET sql_safe_updates = 1;
END IF;

-- Translation Entries
IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName = 'MESSAGING_TRANSLATIONS' AND keyName = 'HOSTEL_NAME_OTHER_LANGUAGE') THEN 
    INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
    VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_NAME_OTHER_LANGUAGE', 'Hostel Name Other Language', 'Hostel Name Other Language', 'Koshuis Naam Ander Taal', 'Tên Ký túc xá Ngôn ngữ khác', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName = 'MESSAGING_TRANSLATIONS' AND keyName = 'CANCELLATION_BY') THEN 
    INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
    VALUES ('MESSAGING_TRANSLATIONS', 'CANCELLATION_BY', 'Cancellation By', 'Cancellation By', 'Kansellasie Deur', 'Hủy bởi', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName = 'MESSAGING_TRANSLATIONS' AND keyName = 'CANCEL_DATE') THEN 
    INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
    VALUES ('MESSAGING_TRANSLATIONS', 'CANCEL_DATE', 'Cancel Date', 'Cancel Date', 'Kanselleer Datum', 'Ngày hủy', NOW(), 1);
END IF;

END $$

CALL V20250722171353__Alter_dataProviderHostelUnAlltStudent() $$

DROP PROCEDURE IF EXISTS V20250722171353__Alter_dataProviderHostelUnAlltStudent $$

DELIMITER ;