DELIMITER $$
DROP PROCEDURE IF EXISTS V20250728144516__Alter_add_printName_column_enquiry $$
CREATE PROCEDURE V20250728144516__Alter_add_printName_column_enquiry()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='enq_student_details' AND column_name='printName')) THEN

    ALTER TABLE enq_student_details
    ADD COLUMN printName VARCHAR(255) NULL AFTER studentLastName;

    ALTER TABLE enq_student_details ADD INDEX printName_idx (printName);

    SET SQL_SAFE_UPDATES=0;

    UPDATE enq_student_details
    SET printName = CONCAT(
        studentFirstName,
        COALESCE(CONCAT(' ', studentMiddleName), ''),
        COALESCE(CONCAT(' ', studentLastName), '')
    );

    SET SQL_SAFE_UPDATES=1;

END IF; 

END $$
CALL V20250728144516__Alter_add_printName_column_enquiry() $$
DROP PROCEDURE IF EXISTS V20250728144516__Alter_add_printName_column_enquiry $$
DELIMITER ;