DELIMITER $$
DROP PROCEDURE IF EXISTS V20250729145505__Alter_SqlDataQuerySendStudentReceiptEvnt $$
CREATE PROCEDURE V20250729145505__Alter_SqlDataQuerySendStudentReceiptEvnt()
BEGIN

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_PAYMENT_ACKNOWLEDGEMENT')) THEN 
SET @dtproviderid = (SELECT id FROM dtprovider WHERE dataProviderName = 'STUDENT_PAYMENT_ACKNOWLEDGEMENT');
  Update sql_dtprovider set sqlQuery = "SELECT 
  RH.id as ID,
    P.emailId as EMAIL_ID,
    P.alternateEmailId as ALTERNATE_EMAIL_ID,
    P.printName AS PRINT_NAME,
    P.firstName AS FIRST_NAME,
    P.middleName AS MIDDLE_NAME,
    P.lastName AS LAST_NAME,
    U.code AS USER_CODE,
    RH.amount AS AMOUNT,
    RH.receiptNo AS RECEIPT_NO,
    RH.transactionDate AS TRANSACTION_DATE,
    FPM.paymentModeName AS PAYMENT_MODE_NAME,
    RH.voucherMode AS VOUCHER_MODE,
    RH.receiptType AS RECEIPT_TYPE
    
FROM 
    receipt_header RH
LEFT JOIN students S ON S.userId = RH.studentId
LEFT JOIN persons P ON P.id = S.personId
LEFT JOIN users U ON U.id = S.userId
LEFT JOIN receipt_payment_instrument RPI ON RPI.receiptHeaderId = RH.id
LEFT JOIN fee_payment_modes FPM ON FPM.id = RPI.paymentMode
WHERE 
    RH.id IN (namedParams)" , jsonString = '{
     "id": 1,
     "searchResultViewColumns": [
    {
            "id": 1,
            "value": "Id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		{
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
			"id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        
        },
        
		 {
            "id": 6,
            "value": "code",
            "resultKey": "USER_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "amount",
            "resultKey": "AMOUNT",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "receiptNo",
            "resultKey": "RECEIPT_NO",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "transactionDate",
            "resultKey": "TRANSACTION_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "paymentModeName",
            "resultKey": "PAYMENT_MODE_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "voucherMode",
            "resultKey": "VOUCHER_MODE",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "receiptType",
            "resultKey": "RECEIPT_TYPE",
            "displayCode": "",
            "displayOrder": 11
        }
        
    ]
 }'  WHERE dataProviderId = @dtproviderid;
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='RECEIPT_TYPE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','RECEIPT_TYPE','Receipt Type','Receipt Type','Soort kwitansie','Loại biên nhận',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='VOUCHER_MODE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','VOUCHER_MODE','Voucher Mode','Voucher Mode','Koopbewysmodus','Chế độ chứng từ',now(),1);
END IF; 



END $$
CALL V20250729145505__Alter_SqlDataQuerySendStudentReceiptEvnt() $$
DROP PROCEDURE IF EXISTS V20250729145505__Alter_SqlDataQuerySendStudentReceiptEvnt $$
DELIMITER ;