DELIMITER $$
DROP PROCEDURE IF EXISTS V20250911122941__Create_student_passout_notifications $$
CREATE PROCEDURE V20250911122941__Create_student_passout_notifications()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_passout_notifications')) THEN 
CREATE TABLE `student_passout_notifications` (
   `id` bigint NOT NULL AUTO_INCREMENT,
   `completionId` bigint NOT NULL,
   `admissionId` bigint DEFAULT NULL,
   `effectiveDate` date DEFAULT NULL,
   `effectivePassoutCommunicationDate` date DEFAULT NULL,
   `passingOutStatus` varchar(255) DEFAULT NULL,
   `isCompletionProcessed` bit(1) DEFAULT NULL,
   `lastUpdatedBy` bigint DEFAULT NULL,
   `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id),                  
    CONSTRAINT fk_student_passout_notifications_completion FOREIGN KEY (completionId) REFERENCES completions(id) ON DELETE CASCADE,
    CONSTRAINT fk_student_passout_notifications_admission FOREIGN KEY (admissionId) REFERENCES admission(id) ON DELETE CASCADE  
  )  ENGINE=InnoDB  AUTO_INCREMENT=2255 DEFAULT CHARSET=utf8mb3;
  
END IF; 

END $$
CALL V20250911122941__Create_student_passout_notifications () $$ 
DROP PROCEDURE IF EXISTS V20250911122941__Create_student_passout_notifications $$ 
DELIMITER ;