DELIMITER $$
DROP PROCEDURE IF EXISTS V20251016183110__Insert_AddColumnMRMaster $$
CREATE PROCEDURE V20251016183110__Insert_AddColumnMRMaster()
BEGIN

SET @standardMasterId = (SELECT id FROM standard_master WHERE masterName = 'MONTHLY_REPORT_MASTER_OSM');

-- check and insert keyHighLightsStatus
IF NOT EXISTS (SELECT id FROM standard_master_items WHERE dbFieldName = 'keyHighLightsStatus' AND standardMasterId = @standardMasterId) THEN
INSERT INTO standard_master_items(dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate)
VALUES ('keyHighLightsStatus', 'KEY_HIGH_LIGHTS_STATUS', @standardMasterId, 'Boolean', 4, b'0', b'0', b'0', b'0', 1, NOW());
END IF;

-- check and insert sequenceNo
IF NOT EXISTS (SELECT id FROM standard_master_items WHERE dbFieldName = 'sequence' AND standardMasterId = @standardMasterId) THEN
INSERT INTO standard_master_items(dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate)
VALUES ('sequence', 'SEQUENCE_NO', @standardMasterId, 'Number', 5, b'0', b'0', b'0', b'0', 1, NOW());
END IF;

-- check and insert parentMonthlyReportMasters
IF NOT EXISTS (SELECT id FROM standard_master_items WHERE dbFieldName = 'parentMonthlyReportMasters' AND standardMasterId = @standardMasterId) THEN
INSERT INTO standard_master_items (dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, fkTable, fkFieldName, fkDisplayField, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate)
VALUES ('parentMonthlyReportMasters', 'MRM_PARENT_ID', @standardMasterId, 'Varchar', 6, b'1', 'monthly_report_master_osm', 'id', 'gridDisplayColumn', b'0', b'1', b'1', 1, NOW());
END IF;



-- Translation----------------------------------------------------------------------------------------------

IF NOT EXISTS (SELECT id FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'MRM_PARENT_ID') THEN 
    INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
    VALUES ('TRANSLATIONS', 'MRM_PARENT_ID', 'MRM Parent ID','MRM Parent ID','MRM Ouer ID','ID gốc MRM', NOW(), 1);
END IF;

IF NOT EXISTS (SELECT id FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'KEY_HIGH_LIGHTS_STATUS') THEN 
    INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
    VALUES ('TRANSLATIONS', 'KEY_HIGH_LIGHTS_STATUS', 'Key High Lights Status','Key High Lights Status','Sleutel High Lights Status','Điểm nổi bật chính', NOW(), 1);
END IF;

END $$
CALL V20251016183110__Insert_AddColumnMRMaster() $$
DROP PROCEDURE IF EXISTS V20251016183110__Insert_AddColumnMRMaster $$
DELIMITER ;