DELIMITER $$
DROP PROCEDURE IF EXISTS V20251023182045__Update_OUTSTANDING_BILL_REM_EVENTS_DL $$
CREATE PROCEDURE V20251023182045__Update_OUTSTANDING_BILL_REM_EVENTS_DL()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STU_REM_ON_DAY_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STU_REM_ON_DAY_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE bh.raiseBillCategory!='BILL_PAYABLE' and
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>false"
WHERE
    (id = @sqldtProviderId);
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STU_REM_ON_DAY_S2_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STU_REM_ON_DAY_S2_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE bh.raiseBillCategory!='BILL_PAYABLE' and
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0"
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0"
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_ON_DAY_S1_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_ON_DAY_S1_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_ON_DAY_S2_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_ON_DAY_S2_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			)
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
          (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			)
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;


IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
            (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			)
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
            (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			) 
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STUDENT_REM_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_STUDENT_REM_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FATHER_REM_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate < DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_MOTHER_REM_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate < DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_DL")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="OUTSTANDING_BILL_FP_REM_DL" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.totalAmount<>0.00
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 "
WHERE
    (id = @sqldtProviderId);
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251023182045__Update_OUTSTANDING_BILL_REM_EVENTS_DL () $$
DROP PROCEDURE IF EXISTS V20251023182045__Update_OUTSTANDING_BILL_REM_EVENTS_DL $$
DELIMITER ;