DELIMITER $$
DROP PROCEDURE IF EXISTS V20251104114717__Insert_DemotionApprovalConfigureLoader $$
CREATE PROCEDURE V20251104114717__Insert_DemotionApprovalConfigureLoader()
BEGIN

SET @importutilitymasterId = (SELECT id FROM import_utility_master WHERE code = 'demotionApproval');
 
    IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'STUDENT_ID' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('STUDENT_ID', 'Student ID', 0, sysdate(), 1, 'Student ID', 1, 1, 1, @importutilitymasterId);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'STUDENT_NAME' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('STUDENT_NAME', 'Student Name', 0, sysdate(), 1, 'Student Name', 1, 1, 1, @importutilitymasterId);
    END IF;
	
	IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'SU_NUMBER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('SU_NUMBER', 'SU Number/External Reference 1', 0, sysdate(), 1, 'SU Number/External Reference 1', 0, 0, 1, @importutilitymasterId);
    END IF;
    
	IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'ADMISSION_ID' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('ADMISSION_ID', 'Admission ID', 0, sysdate(), 1, 'Admission ID', 1, 1, 1, @importutilitymasterId);
    END IF;
	
	IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'ACADEMY_LOCATION' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('ACADEMY_LOCATION', 'Academy Location', 0, sysdate(), 1, 'Academy Location', 1, 1, 1, @importutilitymasterId);
    END IF;
	
	IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'ACADEMIC_TERM' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('ACADEMIC_TERM', 'Academic Term', 0, sysdate(), 1, 'Academic Term', 0, 0, 1, @importutilitymasterId);
    END IF;
	
	IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'PROGRAM_GROUP' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('PROGRAM_GROUP', 'Program Group', 0, sysdate(), 1, 'Program Group', 0, 0, 1, @importutilitymasterId);
    END IF;
	
     IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'PROGRAM' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('PROGRAM', 'Program Code/Name', 0, sysdate(), 1, 'Program Code/Name', 1, 1, 1, @importutilitymasterId);
    END IF;
    
     IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'BATCH' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('BATCH', 'Batch Name', 0, sysdate(), 1, 'Batch Name', 1, 1, 1, @importutilitymasterId);
    END IF;
		
	IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'PERIOD' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('PERIOD', 'Current Period', 0, sysdate(), 1, 'Current Period', 1, 1, 1, @importutilitymasterId);
    END IF;
       
    IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'CURRENT_PROMOTION_STATUS' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('CURRENT_PROMOTION_STATUS', 'Current Promotion Status', 0, sysdate(), 1, 'Current Promotion Status', 1, 1, 1, @importutilitymasterId);
    END IF;
    
    IF NOT EXISTS (SELECT * FROM loader_header WHERE headerCode = 'PERIOD_TO_BE_DEMOTED' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId) THEN
        INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
        VALUES ('PERIOD_TO_BE_DEMOTED', 'Period To Be Demoted', 0, sysdate(), 1, 'Period To Be Demoted', 0, 0, 1, @importutilitymasterId);
    END IF;
	

END $$
CALL V20251104114717__Insert_DemotionApprovalConfigureLoader() $$
DROP PROCEDURE IF EXISTS V20251104114717__Insert_DemotionApprovalConfigureLoader $$
DELIMITER ;