DELIMITER $$
DROP PROCEDURE IF EXISTS V20251106170638__Update_GraduationletterDataProvider $$
CREATE PROCEDURE V20251106170638__Update_GraduationletterDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @dataProviderId=(SELECT id FROM dtprovider where dataProviderName='SERVICE_REQUEST_COMPLAINT_DL');
IF EXISTS ((SELECT id FROM dydt_data_line_item  where dataSourceCode="STUDENT_ADMISSION_PROGRAM_INFO" and publishAsParametersDef="student_id=PRM_STUDENT_ID" and whereClauseBindingDef="PRM_ADMISSION_ID" and dataProviderId=@dataProviderId )) THEN 
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef` = 'SELECT \n        p.programCode AS program_code,\n        p.programName AS program_name,\n        p.programNameToBePrint AS program_print_name,\n        pd.shortCode AS primary_dept_code,\n        pd.deptName AS primary_dept_name,\n        psd.shortCode AS secondary_dept_code,\n        psd.deptName AS secondary_dept_name,\n        b.batchName AS batch_name,\n        b.printName AS batch_printName,\n        sal.salutationName AS student_salutation,\n        DATE_FORMAT(DATE(b.startDate), \'%d-%m-%Y\') AS batch_start_date,\n        DATE_FORMAT(DATE(b.tillDate), \'%d-%m-%Y\') AS batch_tilldate,\n        ay.itemValue AS intake_year,\n        a.code AS admission_code,\n        a.studentId AS student_id,\n        pbpc.programPeriodName AS period_name,\n        pbpc.printName AS period_print_name,\n        prsn.photoUrl AS img_photo_url,\n        DATE_FORMAT(DATE(NOW()), \'%d-%m-%Y\') AS today_date,\n        u.code AS person_code,\n        prsn.firstName AS first_name,\n        prsn.middleName AS middle_name,\n        prsn.lastName AS last_name,\n        (CASE\n            WHEN (prsn.genderId = 1) THEN \'Male\'\n            WHEN (prsn.genderId = 2) THEN \'Female\'\n            WHEN (prsn.genderId = 3) THEN \'Transgender\'\n            ELSE NULL\n        END) AS student_gender,\n        cc.itemValue AS cast_category,\n        DATE_FORMAT(DATE(prsn.birthDate), \'%d-%m-%Y\') AS birth_date,\n        ntn.itemValue AS nationality,\n        rel.itemValue AS religions,\n        sec.sectionCode AS section_code,\n        DATE_FORMAT(a.admissionDate, \'%d-%m-%Y\') AS admission_date,\n        TRUNCATE(DATEDIFF(DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\'),\n                    prsn.birthDate) / 365.25,\n            0) AS student_age,\n        (CASE\n            WHEN (prsn.bloodGroup = \'O_PLUS\') THEN \'O+\'\n            WHEN (prsn.bloodGroup = \'O_MINUS\') THEN \'O-\'\n            WHEN (prsn.bloodGroup = \'A_PLUS\') THEN \'A+\'\n            WHEN (prsn.bloodGroup = \'A_MINUS\') THEN \'A-\'\n            WHEN (prsn.bloodGroup = \'B_PLUS\') THEN \'B+\'\n            WHEN (prsn.bloodGroup = \'B_MINUS\') THEN \'B-\'\n            WHEN (prsn.bloodGroup = \'AB_PLUS\') THEN \'AB+\'\n            WHEN (prsn.bloodGroup = \'AB_MINUS\') THEN \'AB-\'\n            ELSE NULL\n        END) AS blood_group,\n        affUniv.itemValue AS affiliated_University,\n        affUniv.itemValueOtherLanguage AS affiliated_University_other_language,\n        prsn.birth_place AS birth_place,\n        prsn.birth_place_language AS birth_place_other_language,\n        prsn.printNameOtherLanguage AS print_Name_Other_Language,\n        p.programNameLanguageOne AS program_Name_Language_One,\n        md.itemValue AS mode_of_delievery,\n        md.itemValueOtherLanguage AS mode_of_delievery_other_language,\n        dcr.recommendation AS recommendation,\n        pg.groupName AS program_group,\n        co.effectiveDate AS effective_pass_out_date,\n        po.decisionNumber AS decision_number,\n        dd.value AS home_language,\n        prsn.nationalID AS national_id,\n        prsn.category AS Category,\n        heqf.itemValue AS NQF_Level,\n        p.saqaId AS SAQA_Id,\n        replace(b.minProgramCredits,\'.0\',\'\') AS Number_of_Credits,\n        DATE_FORMAT(DATE(pbpc.programPeriodEnd), \'%d %M %Y\') AS Period_End_date,\n        al.displayName AS academy_location_display_name_adm,\n        al.locationName AS academy_location_name_adm,\n        al.academyName AS academy_name_adm,\n        ad.phoneCountryCode AS al_phone_country_code_adm,\n        ad.phoneNo AS al_phone_no_adm,\n        ad.cellCountryCode AS academy_loc_cell_country_code_adm,\n        ad.cellNo AS academy_loc_cell_no_adm,\n        addr.addressText AS addressText_adm,\n        city.cityName AS addressTextCityName_adm,\n        addr.pincode AS addressTextPincode_adm,\n        country.countryName AS addressTextcountryName_adm,\n        ad.primaryeEmailId AS academy_loc_primary_email_id_adm,\n        prsn.mobileCountryCode as mobileCode_STU,\n        prsn.mobileNumber as mobile_number_STU,\n        DATE_FORMAT(DATE(bcd.cf14), \'%d-%m-%Y\') AS batch_end_date\n    FROM\n        program_batch_students pbs\n            LEFT JOIN\n        admission a ON a.id = pbs.admissionId\n            LEFT JOIN\n        batches b ON b.id = pbs.programBatchId\n            LEFT JOIN\n        programs p ON b.programId = p.id\n            LEFT JOIN\n        intake_year ay ON ay.id = b.intakeYearId\n            LEFT JOIN\n        department pd ON pd.id = p.programDepartmentId\n            LEFT JOIN\n        department psd ON psd.id = p.subDepartmentId\n            LEFT JOIN\n        prog_batch_period_config pbpc on pbs.progBatchPeriodConfigId=pbpc.id\n            LEFT JOIN\n        students st ON st.userId = a.studentId\n            LEFT JOIN\n        persons prsn ON prsn.id = st.personId\n            LEFT JOIN\n        users u ON u.id = st.userId\n            LEFT JOIN\n        caste_categories cc ON cc.id = prsn.castCategoryId\n            LEFT JOIN\n        nationalities ntn ON ntn.id = prsn.nationalityId\n            LEFT JOIN\n        religions rel ON rel.id = prsn.religionId\n            LEFT JOIN\n        sections sec ON sec.id = pbs.sectionId\n            LEFT JOIN\n        salutations sal ON sal.id = prsn.salutationId\n            LEFT JOIN\n        affiliated_university affUniv ON affUniv.id = p.affiliatedUniversityId\n            LEFT JOIN\n        mode_of_delivery md ON md.id = p.modeOfDeliveryId\n            LEFT JOIN\n        degree_classification_batch_mapping dcbm ON dcbm.batchId = b.id\n            LEFT JOIN\n        degree_classification_remark dcr ON dcr.degreeClassificationId = dcbm.degreeClassificationId\n            LEFT JOIN\n        program_group pg ON pg.id = p.programGroupId\n            LEFT JOIN\n        completions co ON co.admissionId = a.id\n            AND co.batchId = pbs.programBatchId\n            LEFT JOIN\n        passing_outs po ON po.completionId = co.id\n            LEFT JOIN\n        drop_down dd ON dd.id = prsn.homeLanguage\n            LEFT JOIN\n        heqf_level heqf ON p.heqfLevelId = heqf.id   INNER JOIN\n        academy_location al ON a.academyLocationId = al.id\n            LEFT JOIN\n        location_addresses la ON al.locationId = la.locationId\n            LEFT JOIN\n        address ad ON la.addressId = ad.id\n            AND ad.addressTypeId = 3\n            LEFT OUTER JOIN\n        persons per ON st.personId = per.id\n            LEFT OUTER JOIN\n        person_addresses pa ON per.id = pa.personId\n            AND pa.whetherPrimary = TRUE\n            LEFT OUTER JOIN\n        address addr ON pa.addressId = addr.id\n            LEFT OUTER JOIN\n        city city ON city.id = addr.cityId\n            LEFT OUTER JOIN\n        country country ON country.id = addr.countryId\n     INNER JOIN\n        batches_cd bcd ON b.id = bcd.batchId', `resultColumnsDef` = 'program_code,program_name,program_print_name,batch_printName,student_salutation, primary_dept_code,cast_category,birth_date,\nprimary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_tilldate,intake_year,section_code,\nadmission_code,student_id,last_name,first_name,middle_name,person_code,img_photo_url,period_name,period_print_name,nationality,religions,\ntoday_date,student_age,student_gender,blood_group,admission_date,affiliated_University,affiliated_University_other_language,birth_place,\nbirth_place_other_language,print_Name_Other_Language,program_Name_Language_One,mode_of_delievery,mode_of_delievery_other_language,recommendation,program_group,effective_pass_out_date,decision_number,home_language,national_id,Category,NQF_Level,SAQA_Id,Number_of_Credits,Period_End_date,academy_location_display_name_adm,al_phone_country_code_adm,al_phone_no_adm,academy_loc_cell_country_code_adm,academy_loc_cell_no_adm,addressText_adm,addressTextCityName_adm,addressTextPincode_adm,addressTextcountryName_adm,academy_loc_primary_email_id_adm,mobileCode_STU,mobile_number_STU,batch_end_date,academy_location_name_adm,academy_name_adm' where dataSourceCode="STUDENT_ADMISSION_PROGRAM_INFO" and publishAsParametersDef="student_id=PRM_STUDENT_ID" and whereClauseBindingDef="PRM_ADMISSION_ID" 
and dataProviderId=@dataProviderId ;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251106170638__Update_GraduationletterDataProvider () $$
DROP PROCEDURE IF EXISTS V20251106170638__Update_GraduationletterDataProvider $$
DELIMITER ;