DELIMITER $$
DROP PROCEDURE IF EXISTS V20251219211013__Create_IciciOrangepaymentGatewayHis $$
CREATE PROCEDURE V20251219211013__Create_IciciOrangepaymentGatewayHis()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'icici_orange_payment_gateway') THEN
    CREATE TABLE `icici_orange_payment_gateway` (
        `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
        `academyLocationId` BIGINT(20) NOT NULL,
        `costCenterId` BIGINT(20) NOT NULL,
        `merchantId` VARCHAR(250),
        `payType` VARCHAR(250),
        `transactionType` VARCHAR(250),
        `currency` VARCHAR(250),
        `environmentURL` VARCHAR(1000),
        `secretKey` VARCHAR(1000),
		`customfield1` VARCHAR(1000),
        `customfield2` VARCHAR(1000),
        `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        `lastUpdatedBy` BIGINT(20) NOT NULL,
        PRIMARY KEY (`id`),
            CONSTRAINT UK_ACADEMYLOCATION_MERCHANT
                UNIQUE (academyLocationId, merchantId),
            INDEX `fk_academylocationid_iciciOrange_idx` (`academyLocationId` ASC),
            INDEX `fk_costCenterId_iciciOrange_idx` (`costCenterId` ASC),
            INDEX `fk_icici_iciciOrange_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_icici_orange_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_icici_orange_payment_gateway_costCenterId` 
               FOREIGN KEY (`costCenterId`)
               REFERENCES `cost_centre`(`id`)
				ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_icici_orange_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT
    );
END IF; 

IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'icici_orange_payment_gateway' LIMIT 1) THEN
    SET @standardMasterMaxId = (SELECT COALESCE(MAX(id), 0) FROM standard_master);
    INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
    VALUES (@standardMasterMaxId + 1, 'icici_orange_payment_gateway', 'ICICI_ORANGE', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
END IF;

SET SQL_SAFE_UPDATES = 0;

SET @standardMasterId = (
    SELECT id FROM standard_master
    WHERE tableName = 'icici_orange_payment_gateway'
    ORDER BY id DESC LIMIT 1
);

IF @standardMasterId IS NOT NULL THEN
    UPDATE `standard_master`
    SET `childMaster` = @standardMasterId, `whetherParent` = 1
    WHERE `tableName` = 'standard_payment_gateway';
    
 IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'IciciOrange') THEN
        INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)
        VALUES (@standardMasterId, 'IciciOrange', false, NOW(), 1);
    END IF;
    
IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
		INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
        VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
	END IF;    
 
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'costCenter' AND standardMasterId = @standardMasterId) THEN
		INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
        VALUES ('costCenter', 'COST_CENTER', @standardMasterId, 'Varchar', 2, 1, 'cost_centre', 'id', 'value', 0, 0, 0, 1, SYSDATE());
	END IF;  
 
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'merchantId' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('merchantId', 'MERCHANT_ID', @standardMasterId, 'Varchar', 3, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'payType' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('payType', 'PAY_TYPE', @standardMasterId, 'Varchar', 4, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;

 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'transactionType' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('transactionType', 'TRANSACTION_TYPE', @standardMasterId, 'Varchar', 5, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;    
 
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currency' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('currency', 'CURRENCY', @standardMasterId, 'Varchar', 6, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;
    
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'environmentURL' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('environmentURL', 'ENVIRONMENT_URL', @standardMasterId, 'Varchar', 7, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'secretKey' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('secretKey', 'SECRET_KEY', @standardMasterId, 'Varchar', 8, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customfield1' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('customfield1', 'CUSTOM_FIELD_1', @standardMasterId, 'Varchar', 9, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;
 
 IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customfield2' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('customfield2', 'CUSTOM_FIELD_2', @standardMasterId, 'Varchar', 10, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;
 
 END IF;

SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20251219211013__Create_IciciOrangepaymentGatewayHis () $$ 
DROP PROCEDURE IF EXISTS V20251219211013__Create_IciciOrangepaymentGatewayHis $$ 
DELIMITER ;