DELIMITER $$
DROP PROCEDURE IF EXISTS V20251223164700__Create_BulkRevertToDraft $$
CREATE PROCEDURE V20251223164700__Create_BulkRevertToDraft()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='progression_panel_bulk_revert_to_draft')) THEN 
CREATE TABLE progression_panel_bulk_revert_to_draft (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `progressionPanelId` BIGINT NOT NULL,
    `enrollmentStatus` varchar(255) null,
    `status` BOOLEAN DEFAULT FALSE,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `lastUpdatedBy` BIGINT NOT NULL,
    PRIMARY KEY (`id`),
    CONSTRAINT `fk_progression_panel_bulk_revert_to_draft_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
);
END IF; 

END $$
CALL V20251223164700__Create_BulkRevertToDraft () $$ 
DROP PROCEDURE IF EXISTS V20251223164700__Create_BulkRevertToDraft $$ 
DELIMITER ;