DELIMITER $$
DROP PROCEDURE IF EXISTS V20251224145657__Alter_AddCGIdinParamTable $$
CREATE PROCEDURE V20251224145657__Alter_AddCGIdinParamTable()
BEGIN

IF EXISTS (
        SELECT 1 
        FROM information_schema.tables 
        WHERE table_name = 'program_batch_course_param'
          AND table_schema = DATABASE()
    ) THEN

        IF NOT EXISTS (
            SELECT 1
            FROM information_schema.columns
            WHERE table_name = 'program_batch_course_param'
              AND column_name = 'courseGroupId'
              AND table_schema = DATABASE()
        ) THEN
            ALTER TABLE program_batch_course_param 
            ADD COLUMN courseGroupId BIGINT NULL;
        END IF;

        
        IF NOT EXISTS (
            SELECT 1 
            FROM information_schema.table_constraints 
            WHERE constraint_name = 'fk_linked_course_groups'
              AND table_name = 'program_batch_course_param'
              AND table_schema = DATABASE()
        ) THEN
            ALTER TABLE program_batch_course_param
            ADD CONSTRAINT fk_linked_course_groups
                FOREIGN KEY (courseGroupId)
                REFERENCES course_group(id)
                ON DELETE SET NULL
                ON UPDATE CASCADE;
        END IF;

        IF NOT EXISTS (
            SELECT 1
            FROM information_schema.statistics
            WHERE table_name = 'program_batch_course_param'
              AND index_name = 'idx_linked_course_groups_parent'
              AND table_schema = DATABASE()
        ) THEN
            CREATE INDEX idx_linked_course_groups_parent
            ON program_batch_course_param(courseGroupId);
        END IF;

    END IF;


END $$
CALL V20251224145657__Alter_AddCGIdinParamTable() $$
DROP PROCEDURE IF EXISTS V20251224145657__Alter_AddCGIdinParamTable $$
DELIMITER ;