DELIMITER $$
DROP PROCEDURE IF EXISTS V20251225180410__Create_exam_block $$
CREATE PROCEDURE V20251225180410__Create_exam_block()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_block')) THEN 
CREATE TABLE `exam_block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `examCenterId` bigint NOT NULL,
  `fromDate` datetime NOT NULL,
  `tillDate` datetime NOT NULL,
  `studentCanSelectCenter` tinyint(1) DEFAULT '0',
  `onlineExamApplicable` tinyint(1) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_exam_block_code` (`code`),
  KEY `idx_exam_block_examCenterId` (`examCenterId`),
  KEY `idx_exam_block_status_date` (`status`,`fromDate`,`tillDate`),
  KEY `exam_block_lastUpdatedBy_fk` (`lastUpdatedBy`),
  CONSTRAINT `exam_block_exam_center_fk` FOREIGN KEY (`examCenterId`) REFERENCES `exam_center` (`id`),
  CONSTRAINT `exam_block_lastUpdatedBy_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20251225180410__Create_exam_block () $$ 
DROP PROCEDURE IF EXISTS V20251225180410__Create_exam_block $$ 
DELIMITER ;