DELIMITER $$
DROP PROCEDURE IF EXISTS V20251226161350__Create_assessmentSchedules $$
CREATE PROCEDURE V20251226161350__Create_assessmentSchedules()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='assessment_schedules')) THEN 
CREATE TABLE `assessment_schedules` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT NOT NULL,
  `academicTermId` BIGINT NOT NULL,
  `eventId` BIGINT DEFAULT NULL,
  `programId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL ,
  `courseId` BIGINT NOT NULL,
  `subTypeId` BIGINT DEFAULT NULL,
  `academicTermCode` VARCHAR(255) DEFAULT NULL,
  `programCode` VARCHAR(255) DEFAULT NULL,
  `qualificationFaculty` VARCHAR(255) DEFAULT NULL,
  `batchName` VARCHAR(255) DEFAULT NULL,
  `periodName` VARCHAR(255) DEFAULT NULL,
  `courseCode` VARCHAR(255) DEFAULT NULL,
  `courseName` VARCHAR(255) DEFAULT NULL,
  `camsQualCode` VARCHAR(255) DEFAULT NULL,
  `camsProgramCode` VARCHAR(255) DEFAULT NULL,
  `camsModuleCode` VARCHAR(255) DEFAULT NULL,
  `subTypeName` VARCHAR(255) DEFAULT NULL,
  `nqfLevel` VARCHAR(255) DEFAULT NULL,
  `brandCode` VARCHAR(255) DEFAULT NULL,
  `campus` VARCHAR(255) DEFAULT NULL,
  `modeOfDelivery` VARCHAR(255) DEFAULT NULL,  
  `templateName` VARCHAR(255) NOT NULL,          
  `periodStartDate` DATETIME DEFAULT NULL,
  `periodEndDate` DATETIME DEFAULT NULL,
  `moduleCredits` FLOAT DEFAULT NULL,
  `weighting` FLOAT DEFAULT NULL,
  `totalPoints` FLOAT DEFAULT NULL,
  `duration` FLOAT DEFAULT NULL,
  `status` TINYINT(1) NULL DEFAULT 0,
  `yearModule` TINYINT(1) NULL DEFAULT 0,
  `ilmsModule` TINYINT(1) NULL DEFAULT 0,
  `eventName` VARCHAR(255) DEFAULT NULL,
  `date` DATE DEFAULT NULL,
  `time` TIME DEFAULT NULL,
  `venueCode` VARCHAR(255) DEFAULT NULL, 
  `invigilator` VARCHAR(255) DEFAULT NULL, 
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_assessment_schedules_academyLocationId` (`academyLocationId`),
  KEY `idx_assessment_schedules_programId` (`programId`),
  KEY `idx_assessment_schedules_batchId` (`batchId`),
  KEY `idx_assessment_schedules_periodId` (`periodId`),
  KEY `idx_assessment_schedules_courseId` (`courseId`),
  KEY `idx_assessment_schedules_eventId` (`eventId`),
  KEY `idx_assessment_schedules_subtypeId` (`subTypeId`),
  KEY `assessment_schedules_lastUpdatedBy` (`lastUpdatedBy`),
  UNIQUE KEY `assessment_schedules_unique_key` (`periodId`,`eventId`,`courseId`),
  CONSTRAINT `assessment_schedules_academyLocation_fk` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `assessment_schedules_program_fk` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `assessment_schedules_batch_fk` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `assessment_schedules_period_fk` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `assessment_schedules_course_fk` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `assessment_schedules_event_fk` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`),
  CONSTRAINT `assessment_schedules_subtype_fk` FOREIGN KEY (`subTypeId`) REFERENCES `evaluation_plan_level_two` (`id`),
  CONSTRAINT `assessment_schedules_lastUpdatedBy_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
  ) ENGINE=InnoDB;
END IF; 

END $$
CALL V20251226161350__Create_assessmentSchedules () $$ 
DROP PROCEDURE IF EXISTS V20251226161350__Create_assessmentSchedules $$ 
DELIMITER ;