DELIMITER $$
DROP PROCEDURE IF EXISTS V20251230180959__Create_FinalStudentCourseEnrollment $$
CREATE PROCEDURE V20251230180959__Create_FinalStudentCourseEnrollment()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='final_student_course_allocation')) THEN 
CREATE TABLE `final_student_course_allocation` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NULL,
  `studentId` BIGINT NULL,
  `courseId` BIGINT NULL,
  `courseVariantId` BIGINT NULL,
  `periodId` BIGINT NULL,
  `priority` BIGINT NULL,
  `isEnrolled` bit(1) NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_FinalStudentCourseAllocation_admission_idx` (`admissionId` ASC) ,
  INDEX `fk_FinalStudentCourseAllocation_student_idx` (`studentId` ASC) ,
  INDEX `fk_FinalStudentCourseAllocation_course_idx` (`courseId` ASC) ,
  INDEX `fk_FinalStudentCourseAllocation_courseVariant_idx` (`courseVariantId` ASC) ,
  INDEX `fk_FinalStudentCourseAllocation_period_idx` (`periodId` ASC),
  CONSTRAINT `fk_FinalStudentCourseAllocation_admission`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_FinalStudentCourseAllocation_student`
    FOREIGN KEY (`studentId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	 CONSTRAINT `fk_FinalStudentCourseAllocation_courseVariant`
    FOREIGN KEY (`courseVariantId`)
    REFERENCES `course_variants` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	 CONSTRAINT `fk_FinalStudentCourseAllocation_period`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_FinalStudentCourseAllocation_course`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF;

END $$
CALL V20251230180959__Create_FinalStudentCourseEnrollment () $$ 
DROP PROCEDURE IF EXISTS V20251230180959__Create_FinalStudentCourseEnrollment $$ 
DELIMITER ;