DELIMITER $$
DROP PROCEDURE IF EXISTS V20251231151413__Create_exam_center_amenities_mapping $$
CREATE PROCEDURE V20251231151413__Create_exam_center_amenities_mapping()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_center_amenities_mapping') THEN
CREATE TABLE exam_center_amenities_mapping (
    id BIGINT NOT NULL AUTO_INCREMENT,
    examCenterId BIGINT NOT NULL,
    amenitiesId BIGINT NOT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT NOT NULL,

    PRIMARY KEY (id),

    UNIQUE KEY uk_exam_center_amenities (examCenterId, amenitiesId),

    KEY idx_exam_center_amenities_mapping_exam_center_id (examCenterId),
    KEY idx_exam_center_amenities_mapping_amenities_id (amenitiesId),
    KEY idx_exam_center_amenities_mapping_last_updated_by (lastUpdatedBy),

    CONSTRAINT fk_exam_center_amenities_mapping_ecam_exam_center
        FOREIGN KEY (examCenterId) REFERENCES exam_center (id),

    CONSTRAINT fk_exam_center_amenities_mapping_amenities
        FOREIGN KEY (amenitiesId) REFERENCES amenities (id),

    CONSTRAINT fk_exam_center_amenities_mapping_last_updated_by
        FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);

END IF; 

END $$
CALL V20251231151413__Create_exam_center_amenities_mapping () $$ 
DROP PROCEDURE IF EXISTS V20251231151413__Create_exam_center_amenities_mapping $$ 
DELIMITER ;