DELIMITER $$

DROP PROCEDURE IF EXISTS V20260102192736__Insert_Terms_and_Condition $$

CREATE PROCEDURE V20260102192736__Insert_Terms_and_Condition()
BEGIN
    DECLARE v_termsId BIGINT DEFAULT 
    NULL;

    IF NOT EXISTS (SELECT 1 FROM terms_and_condition) THEN

        INSERT INTO terms_and_condition
        (
            isAdmin,
            isFaculty,
            isStudent,
            isParent,
            isApplicant,
            isAlumini,
            termsAndCondition,
            numberOfDays
        )
        VALUES
        (
            b'1', b'1', b'1', b'1', b'1', b'1',
            'Compliance & Conduct – Users must adhere to all applicable laws, policies, and ethical guidelines while engaging with this platform.
&&&Privacy & Data Protection – Your login credentials and personal data will be processed in accordance with our privacy policy.
&&&Access & Restrictions – The platform reserves the right to limit, suspend, or terminate user access if any violations of these terms are detected.
&&&Modification of Terms – The terms and conditions may be updated periodically. Continued use of this platform constitutes acceptance of any revised policies',
            30
        );

        SET v_termsId = LAST_INSERT_ID();

        INSERT INTO terms_and_condition_url
        (
            termsAndConditionCSMId,
            linkTitle,
            link
        )
        VALUES
        (
            v_termsId,
            'Terms and Condition',
            'https://www.academiaerp.com/terms-and-condition/'
        );

    END IF;
    
IF EXISTS (
        SELECT 1
        FROM information_schema.tables
        WHERE table_schema = DATABASE()
          AND table_name = 'terms_and_conditions_acceptance_logs'
    ) THEN
        ALTER TABLE terms_and_conditions_acceptance_logs
        MODIFY acceptanceDate TIMESTAMP;
    END IF;
 SET SQL_SAFE_UPDATES=0;   
 UPDATE standard_master_items SET maxLength = '2000' WHERE dbFieldName = 'termsAndCondition' and fieldLabel ='TERMSANDCONDITION';
 UPDATE standard_master_items SET maxLength = '20' WHERE dbFieldName = 'linkTitle' and fieldLabel ='LINKTITLE';
 SET SQL_SAFE_UPDATES=1;


END $$
CALL V20260102192736__Insert_Terms_and_Condition() $$
DROP PROCEDURE IF EXISTS V20260102192736__Insert_Terms_and_Condition $$
DELIMITER ;