DELIMITER $$
DROP PROCEDURE IF EXISTS V20260107112924__Delete_Effective_Date_Student_Transfer $$
CREATE PROCEDURE V20260107112924__Delete_Effective_Date_Student_Transfer()
BEGIN

 SET SQL_SAFE_UPDATES = 0;

    IF EXISTS (
        SELECT 1
        FROM form_field_info
        WHERE formAliasName = 'studenttransferrequestresponsive'
          AND formFieldName = 'effectiveWithdrawlProgramDate'
          AND formFieldId   = 'effectiveWithdrawlProgramDate'
    ) THEN

        SET @formFieldInfoId = (
            SELECT id
            FROM form_field_info
            WHERE formAliasName = 'studenttransferrequestresponsive'
              AND formFieldName = 'effectiveWithdrawlProgramDate'
              AND formFieldId   = 'effectiveWithdrawlProgramDate'
            LIMIT 1
        );

        IF EXISTS (
            SELECT 1
            FROM form_field_display_settings
            WHERE formFieldInfoId = @formFieldInfoId
        ) THEN

            SET @formFieldDisplaySettingId = (
                SELECT id
                FROM form_field_display_settings
                WHERE formFieldInfoId = @formFieldInfoId
                LIMIT 1
            );

            IF EXISTS (
                SELECT 1
                FROM form_field_helptext_lang_translation
                WHERE formFieldDisplaySettingsId = @formFieldDisplaySettingId
            ) THEN
                DELETE
                FROM form_field_helptext_lang_translation
                WHERE formFieldDisplaySettingsId = @formFieldDisplaySettingId;
            END IF;

            DELETE
            FROM form_field_display_settings
            WHERE formFieldInfoId = @formFieldInfoId;

        END IF;

        DELETE
        FROM form_field_info
        WHERE id = @formFieldInfoId;

    END IF;

    SET SQL_SAFE_UPDATES = 1;


END $$
CALL V20260107112924__Delete_Effective_Date_Student_Transfer() $$
DROP PROCEDURE IF EXISTS V20260107112924__Delete_Effective_Date_Student_Transfer $$
DELIMITER ;