DELIMITER $$
DROP PROCEDURE IF EXISTS V20260109112824__Update_AddGoogleAddressDtProvider $$
CREATE PROCEDURE V20260109112824__Update_AddGoogleAddressDtProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
Set @dataProviderId= (select id from dtprovider where dataProviderName='DIRECT_ADMISSION_CREATE_STUDENT_DL_DTP');
IF  EXISTS (((select id from `dydt_data_line_item` where dataSourceCode='STUDENT_ADDRESS_INFO' and dataProviderId=@dataProviderId))) THEN 
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef` = 'SELECT \n    addr.addressText AS addressText,\n    city.cityName AS addressTextCityName,\n    addr.pincode AS addressTextPincode,\n    country.countryName AS addressTextcountryName,\n    ag.addressText AS addressText_google,\n    cityg.cityName AS addressTextCityName_google,\n    ag.pincode AS addressTextPincode_google,\n    countryg.countryName AS addressTextcountryName_google\nFROM students s\nLEFT OUTER JOIN persons p \n       ON s.personId = p.id\n\n-- Primary address\nLEFT OUTER JOIN person_addresses pa  \n       ON p.id = pa.personId \n      AND pa.whetherPrimary = TRUE\nLEFT OUTER JOIN address addr \n       ON pa.addressId = addr.id\nLEFT OUTER JOIN city city \n       ON city.id = addr.cityId\nLEFT OUTER JOIN country country \n       ON country.id = city.countryId\n\n-- Google address (addressTypeId dynamically fetched)\nLEFT OUTER JOIN person_addresses pag \n       ON p.id = pag.personId \n      AND pag.addressTypeId = (SELECT id FROM address_type WHERE code = \'GOOGLE\')\nLEFT OUTER JOIN address ag \n       ON pag.addressId = ag.id\nLEFT OUTER JOIN city cityg \n       ON cityg.id = ag.cityId\nLEFT OUTER JOIN country countryg \n       ON countryg.id = cityg.countryId', `resultColumnsDef` = 'addressText,addressTextCityName,addressTextPincode,addressTextcountryName,addressText_google,addressTextCityName_google,addressTextPincode_google,addressTextcountryName_google' WHERE dataSourceCode='STUDENT_ADDRESS_INFO' and dataProviderId=@dataProviderId ;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20260109112824__Update_AddGoogleAddressDtProvider () $$
DROP PROCEDURE IF EXISTS V20260109112824__Update_AddGoogleAddressDtProvider $$
DELIMITER ;