DELIMITER $$
DROP PROCEDURE IF EXISTS V20260112112103__Insert_priorityEnrollmentInsert $$
CREATE PROCEDURE V20260112112103__Insert_priorityEnrollmentInsert()
BEGIN

  IF EXISTS (
    SELECT 1 
    FROM information_schema.TABLES 
    WHERE TABLE_SCHEMA = DATABASE()
      AND TABLE_NAME = 'student_profile_link'
) THEN

    -- Check record exists before insert
    IF NOT EXISTS (
        SELECT 1 
        FROM student_profile_link 
        WHERE linkName = 'Priority Based Enrollement'
    ) THEN
        INSERT INTO student_profile_link
        (
            linkName,
            sequenceNo,
            lastUpdatedBy,
            lastUpdate
        )
        VALUES
        (
            'Priority Based Enrollement',
            13,
            1,
            NOW()
        );
    END IF;

END IF;

-- Check table term_wise_profile_link exists
IF EXISTS (
    SELECT 1 
    FROM information_schema.TABLES 
    WHERE TABLE_SCHEMA = DATABASE()
      AND TABLE_NAME = 'term_wise_profile_link'
) THEN
   
   INSERT INTO term_wise_profile_link
(
    lastUpdate,
    lastUpdatedBy,
    isSelected,
    sequenceNo,
    linkName,
    termWiseProfileUpdateId
)
SELECT 
    NOW(),
    1,                      
    0,                         
    (
        SELECT COALESCE(MAX(sequenceNo), 0) + 1
        FROM term_wise_profile_link
        WHERE termWiseProfileUpdateId = twpu.id
    ),
    'Priority Based Enrollement',
    twpu.id
FROM term_wise_profile_update twpu
WHERE twpu.registrationTermSetupDetailId 
  AND NOT EXISTS (
        SELECT 1 
        FROM term_wise_profile_link t
        WHERE t.termWiseProfileUpdateId = twpu.id
          AND t.linkName = 'Priority Based Enrollement'
    );
    END IF;
 

END $$
CALL V20260112112103__Insert_priorityEnrollmentInsert() $$
DROP PROCEDURE IF EXISTS V20260112112103__Insert_priorityEnrollmentInsert $$
DELIMITER ;