CREATE TABLE checklist_items (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	itemCode VARCHAR(255) NOT NULL ,
	itemValue VARCHAR(255) NOT NULL ,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);

CREATE TABLE program_withdrawal_reasons (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	itemCode VARCHAR(255) NOT NULL ,
	itemValue VARCHAR(255) NOT NULL ,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);
	

CREATE TABLE transaction_types (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	itemCode VARCHAR(255) NOT NULL ,
	itemValue VARCHAR(255) NOT NULL ,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);

	
CREATE TABLE completions (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	version BIGINT(20) NOT NULL,
	whetherDeleted TINYINT(1) NULL DEFAULT NULL,
	effectiveDate DATETIME NULL DEFAULT NULL,
	remark VARCHAR(255) NULL DEFAULT NULL ,
	status VARCHAR(255) NULL DEFAULT NULL ,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	admissionId BIGINT(20) NULL DEFAULT NULL,
	batchId BIGINT(20) NULL DEFAULT NULL,
	programId BIGINT(20) NULL DEFAULT NULL,
	sectionId BIGINT(20) NULL DEFAULT NULL,
	studentId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);
	

CREATE TABLE completion_checklists (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	academyLocationId BIGINT(20) NULL DEFAULT NULL,
	batchId BIGINT(20) NULL DEFAULT NULL,
	programId BIGINT(20) NULL DEFAULT NULL,
	seatTypeId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);
	

CREATE TABLE completion_documents (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	completionId BIGINT(20) NULL DEFAULT NULL,
	documentId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);

	
CREATE TABLE completion_trans_type_certs (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	whetherComplete TINYINT(1) NULL DEFAULT NULL,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	completionId BIGINT(20) NULL DEFAULT NULL,
	transTypeCertificateId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);
	

CREATE TABLE completion_trans_type_checks (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	version BIGINT(20) NOT NULL,
	whetherDeleted TINYINT(1) NULL DEFAULT NULL,
	whetherComplete TINYINT(1) NULL DEFAULT NULL,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	completionId BIGINT(20) NULL DEFAULT NULL,
	transTypeChecklistItemId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);
	

CREATE TABLE passing_outs (
	completionId BIGINT(20) NOT NULL,
	PRIMARY KEY (completionId)
);
	

CREATE TABLE program_withdrawals (
	tillDate DATETIME NULL DEFAULT NULL,
	completionId BIGINT(20) NOT NULL,
	approvedBy BIGINT(20) NULL DEFAULT NULL,
	serviceRequestId BIGINT(20) NULL DEFAULT NULL,
	reasonId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (completionId)
);


CREATE TABLE temp_terminations (
	studentRemark VARCHAR(255) NULL DEFAULT NULL ,
	tillDate DATETIME NULL DEFAULT NULL,
	completionId BIGINT(20) NOT NULL,
	approvedBy BIGINT(20) NULL DEFAULT NULL,
	serviceRequestId BIGINT(20) NULL DEFAULT NULL,
	reasonId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (completionId)
);
	

CREATE TABLE terminations (
	studentRemark VARCHAR(255) NULL DEFAULT NULL ,
	completionId BIGINT(20) NOT NULL,
	approvedBy BIGINT(20) NULL DEFAULT NULL,
	serviceRequestId BIGINT(20) NULL DEFAULT NULL,
	reasonId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (completionId)
);


CREATE TABLE transaction_type_certificates (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	certificateId BIGINT(20) NULL DEFAULT NULL,
	transactionTypeId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);


CREATE TABLE transaction_type_checklists (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
	lastUpdate DATETIME NOT NULL,
	lastUpdatedBy BIGINT(20) NULL DEFAULT NULL,
	checklistItemId BIGINT(20) NULL DEFAULT NULL,
	transactionTypeId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (id)
);

	
CREATE TABLE transfers (
	tillDate DATETIME NULL DEFAULT NULL,
	completionId BIGINT(20) NOT NULL,
	approvedBy BIGINT(20) NULL DEFAULT NULL,
	serviceRequestId BIGINT(20) NULL DEFAULT NULL,
	reasonId BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (completionId)
);
	

CREATE TABLE compln_check_trans_certs (
	completionCheckListId BIGINT(20) NOT NULL,
	transactionTypeCertId BIGINT(20) NOT NULL,
	PRIMARY KEY (completionCheckListId, transactionTypeCertId)
);


CREATE TABLE compln_check_trans_checks (
	completionCheckListId BIGINT(20) NOT NULL,
	transactionTypeChecklistId BIGINT(20) NOT NULL,
	PRIMARY KEY (completionCheckListId, transactionTypeChecklistId)
);

ALTER TABLE checklist_items ADD CONSTRAINT FK_ci_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);
	
ALTER TABLE program_withdrawal_reasons ADD CONSTRAINT FK_pwr_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);
	
ALTER TABLE transaction_types ADD CONSTRAINT FK_tt_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);

ALTER TABLE completions ADD CONSTRAINT FK_c_admission_admissionId 
    FOREIGN KEY (admissionId)
    REFERENCES admission (id);
ALTER TABLE completions ADD CONSTRAINT FK_c_batches_batchId 
    FOREIGN KEY (batchId)
    REFERENCES batches (id);
ALTER TABLE completions ADD CONSTRAINT FK_c_programs_programId 
    FOREIGN KEY (programId)
    REFERENCES programs (id);
ALTER TABLE completions ADD CONSTRAINT FK_c_students_studentId 
    FOREIGN KEY (studentId)
    REFERENCES students (personId);
ALTER TABLE completions ADD CONSTRAINT FK_c_sections_sectionId 
    FOREIGN KEY (sectionId)
    REFERENCES sections (id);
ALTER TABLE completions ADD CONSTRAINT FK_c_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);	

ALTER TABLE completion_checklists ADD CONSTRAINT FK_cc_academy_location_academyLocationId
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location (id);
ALTER TABLE completion_checklists ADD CONSTRAINT FK_cc_batches_batchId 
    FOREIGN KEY (batchId)
    REFERENCES batches (id);
ALTER TABLE completion_checklists ADD CONSTRAINT FK_cc_programs_programId 
    FOREIGN KEY (programId)
    REFERENCES programs (id);
ALTER TABLE completion_checklists ADD CONSTRAINT FK_cc_seat_types_seatTypeId 
    FOREIGN KEY (seatTypeId)
    REFERENCES seat_types (id);
ALTER TABLE completion_checklists ADD CONSTRAINT FK_cc_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);


ALTER TABLE completion_documents ADD CONSTRAINT FK_cd_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);
ALTER TABLE completion_documents ADD CONSTRAINT FK_cd_extended_documents_documentId 
    FOREIGN KEY (documentId)
    REFERENCES extended_documents (documentId);
ALTER TABLE completion_documents ADD CONSTRAINT FK_cd_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);

ALTER TABLE completion_trans_type_certs ADD CONSTRAINT FK_cttc_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);
ALTER TABLE completion_trans_type_certs ADD CONSTRAINT FK_cttc_ttcs_transTypeCertificateId 
    FOREIGN KEY (transTypeCertificateId)
    REFERENCES transaction_type_certificates (id);
ALTER TABLE completion_trans_type_certs ADD CONSTRAINT FK_cttc_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);

ALTER TABLE completion_trans_type_checks ADD CONSTRAINT FK_cttcs_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);
ALTER TABLE completion_trans_type_checks ADD CONSTRAINT FK_cttcs_ttcs_transTypeChecklistItemId
    FOREIGN KEY (transTypeChecklistItemId)
    REFERENCES transaction_type_checklists (id);
ALTER TABLE completion_trans_type_checks ADD CONSTRAINT FK_cttcs_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);

ALTER TABLE passing_outs ADD CONSTRAINT FK_po_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);

ALTER TABLE program_withdrawals ADD CONSTRAINT FK_pw_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);
ALTER TABLE program_withdrawals ADD CONSTRAINT FK_pw_program_withdrawal_reasons_reasonId
    FOREIGN KEY (reasonId)
    REFERENCES program_withdrawal_reasons (id);
ALTER TABLE program_withdrawals ADD CONSTRAINT FK_pw_users_approvedBy 
    FOREIGN KEY (approvedBy)
    REFERENCES users (id);
ALTER TABLE program_withdrawals ADD CONSTRAINT FK_pw_service_requests_serviceRequestId
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests (id);


ALTER TABLE temp_terminations ADD CONSTRAINT FK_tts_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);
ALTER TABLE temp_terminations ADD CONSTRAINT FK_tts_termination_reasons_reasonId
    FOREIGN KEY (reasonId)
    REFERENCES termination_reasons (id);
ALTER TABLE temp_terminations ADD CONSTRAINT FK_tts_users_approvedBy 
    FOREIGN KEY (approvedBy)
    REFERENCES users (id);
ALTER TABLE temp_terminations ADD CONSTRAINT FK_tts_service_requests_serviceRequestId
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests (id);

ALTER TABLE terminations ADD CONSTRAINT FK_t_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);
ALTER TABLE terminations ADD CONSTRAINT FK_t_termination_reasons_reasonId
    FOREIGN KEY (reasonId)
    REFERENCES termination_reasons (id);
ALTER TABLE terminations ADD CONSTRAINT FK_t_users_approvedBy 
    FOREIGN KEY (approvedBy)
    REFERENCES users (id);
ALTER TABLE terminations ADD CONSTRAINT FK_t_service_requests_serviceRequestId
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests (id);

ALTER TABLE transaction_type_certificates ADD CONSTRAINT FK_ttc_transaction_types_transactionTypeId 
    FOREIGN KEY (transactionTypeId)
    REFERENCES transaction_types (id);
ALTER TABLE transaction_type_certificates ADD CONSTRAINT FK_ttc_certificates_certificateId
    FOREIGN KEY (certificateId)
    REFERENCES certificates (id);
ALTER TABLE transaction_type_certificates ADD CONSTRAINT FK_ttc_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);


ALTER TABLE transaction_type_checklists ADD CONSTRAINT FK_ttcs_transaction_types_transactionTypeId 
    FOREIGN KEY (transactionTypeId)
    REFERENCES transaction_types (id);
ALTER TABLE transaction_type_checklists ADD CONSTRAINT FK_ttcs_checklist_items_checklistItemId
    FOREIGN KEY (checklistItemId)
    REFERENCES checklist_items (id);
ALTER TABLE transaction_type_checklists ADD CONSTRAINT FK_ttcs_users_lastUpdatedBy 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id);	
	
ALTER TABLE transfers ADD CONSTRAINT FK_ts_completions_completionId 
    FOREIGN KEY (completionId)
    REFERENCES completions (id);
ALTER TABLE transfers ADD CONSTRAINT FK_ts_transfer_reasons_reasonId
    FOREIGN KEY (reasonId)
    REFERENCES transfer_reasons (id);
ALTER TABLE transfers ADD CONSTRAINT FK_ts_users_approvedBy 
    FOREIGN KEY (approvedBy)
    REFERENCES users (id);
ALTER TABLE transfers ADD CONSTRAINT FK_ts_sr_serviceRequestId
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests (id);	

ALTER TABLE compln_check_trans_certs ADD CONSTRAINT FK_cctc_cc_completionCheckListId 
    FOREIGN KEY (completionCheckListId)
    REFERENCES completion_checklists (id);
ALTER TABLE compln_check_trans_certs ADD CONSTRAINT FK_cctc_ttc_transactionTypeCertId
    FOREIGN KEY (transactionTypeCertId)
    REFERENCES transaction_type_certificates (id);
	
ALTER TABLE compln_check_trans_checks ADD CONSTRAINT FK_cctcs_cc_completionCheckListId 
    FOREIGN KEY (completionCheckListId)
    REFERENCES completion_checklists (id);
ALTER TABLE compln_check_trans_checks ADD CONSTRAINT FK_cctcs_ttc_transactionTypeChecklistId
    FOREIGN KEY (transactionTypeChecklistId)
    REFERENCES transaction_type_checklists (id);
    
ALTER TABLE documents
	CHANGE COLUMN name documentName VARCHAR(255) NULL DEFAULT NULL;    