CREATE TABLE `faculty_attendance_dashboard_faculty_wise` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `facultyId` bigint(20) NOT NULL,
  `totalRecords` bigint(20) NOT NULL,
  `presentRecords` bigint(20) NOT NULL,
  `absentRecords` bigint(20) NOT NULL,
  `presentPercentage` int(3) NOT NULL,
  `absentPercentage` int(3) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `faculty_attendance_dashboard_faculty_wise_1` (`academyLocationId`),
  KEY `faculty_attendance_dashboard_faculty_wise_2` (`facultyId`),
  KEY `faculty_attendance_dashboard_faculty_wise_3` (`lastUpdatedBy`),
  CONSTRAINT `faculty_attendance_dashboard_faculty_wise_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `faculty_attendance_dashboard_faculty_wise_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `faculty_attendance_dashboard_faculty_wise_2` FOREIGN KEY (`facultyId`) REFERENCES `staffs` (`userId`)
);

CREATE TABLE `student_attendance_dashboard_student_wise` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `programId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `totalRecords` bigint(20) NOT NULL,
  `presentRecords` bigint(20) NOT NULL,
  `absentRecords` bigint(20) NOT NULL,
  `absentPercentage` int(3) NOT NULL,
  `presentPercentage` int(3) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_attendance_dashboard_student_wise_1_idx` (`academyLocationId`),
  KEY `fk_attendance_dashboard_student_wise_2_idx` (`programId`),
  KEY `fk_attendance_dashboard_student_wise_3_idx` (`batchId`),
  KEY `fk_attendance_dashboard_student_wise_4_idx` (`periodId`),
  KEY `fk_attendance_dashboard_student_wise_5_idx` (`sectionId`),
  KEY `fk_attendance_dashboard_student_wise_6_idx` (`admissionId`),
  KEY `fk_attendance_dashboard_student_wise_7_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_7` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_2` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_3` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_4` FOREIGN KEY (`periodId`) REFERENCES `prog_period_break_config` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_5` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_6` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`)
);

CREATE TABLE `student_attendance_dashboard_section_wise` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `componentId` bigint(20) DEFAULT NULL,
  `date` date NOT NULL,
  `totalRecords` bigint(20) DEFAULT NULL,
  `presentRecords` bigint(20) DEFAULT NULL,
  `absentRecords` bigint(20) DEFAULT NULL,
  `absentPercentage` int(3) DEFAULT NULL,
  `presentPercentage` int(3) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_attendance_dashboard_section_wise_1_idx` (`academyLocationId`),
  KEY `fk_attendance_dashboard_section_wise_2_idx` (`programId`),
  KEY `fk_attendance_dashboard_section_wise_3_idx` (`batchId`),
  KEY `fk_attendance_dashboard_section_wise_4_idx` (`periodId`),
  KEY `fk_attendance_dashboard_section_wise_5_idx` (`sectionId`),
  KEY `fk_attendance_dashboard_section_wise_6_idx` (`courseId`),
  KEY `fk_attendance_dashboard_section_wise_7_idx` (`componentId`),
  KEY `fk_attendance_dashboard_section_wise_8_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_2` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_3` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_4` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_5` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_6` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_7` FOREIGN KEY (`componentId`) REFERENCES `course_components` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_8` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `student_attendance_dashboard_section_wise_total` AS
    select 
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `sections`.`sectionCode` AS `sectionCode`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        floor(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100)) AS `presentPercent`,
        floor(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100)) AS `absentPercent`
    from
        (`student_attendance_dashboard_section_wise`
        left join `sections` ON ((`student_attendance_dashboard_section_wise`.`sectionId` = `sections`.`id`)))
    group by `student_attendance_dashboard_section_wise`.`sectionId`;
