
set foreign_key_checks=0;
ALTER TABLE `evaluation_group_document` 
CHANGE COLUMN `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT ;


DROP TABLE IF EXISTS `evaluation_group_applicant`;
CREATE TABLE `evaluation_group_applicant` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `admissionId` bigint(20) NOT NULL,
  `evaluationGroupId` bigint(20) NOT NULL,
  `hallticket` varchar(255) DEFAULT NULL,
  `applicationNumber` varchar(255) DEFAULT NULL,
  `applicationStatus` varchar(100) DEFAULT NULL COMMENT 'Pending, Submitted, Rejected, Approved, Withdrawn, Deleted',
  `centerStatus` varchar(100) DEFAULT NULL COMMENT 'Allocation Pending/ Allocation Complete',
  `roomAllocationStatus` varchar(100) DEFAULT NULL COMMENT 'Allocation Pending/ Allocation Complete',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refadmission8797_idx` (`admissionId`),
  KEY `Refevaluationgroup989_idx` (`evaluationGroupId`),
  KEY `Refusers7876_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refadmission8797` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refevaluationgroup989` FOREIGN KEY (`evaluationGroupId`) REFERENCES `evaluation_group` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers7876` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `evaluation_group_applicant_sequence`;
CREATE TABLE `evaluation_group_applicant_sequence` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationGroupApplicantId` bigint(20) NOT NULL,
  `evaluationDetailSequenceId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'PASS/FAIL',
  PRIMARY KEY (`id`),
  KEY `Refdetailsequence897_idx` (`evaluationDetailSequenceId`),
  KEY `Refusers0922_idx` (`lastUpdatedBy`),
  KEY `Refapplicant1212_idx` (`evaluationGroupApplicantId`),
  CONSTRAINT `Refapplicant1212` FOREIGN KEY (`evaluationGroupApplicantId`) REFERENCES `evaluation_group_applicant` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refdetailsequence897` FOREIGN KEY (`evaluationDetailSequenceId`) REFERENCES `eval_seq_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers0922` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `evaluation_group_applicant_document`;
CREATE TABLE `evaluation_group_applicant_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `admissionId` bigint(20) NOT NULL,
  `evaluationGroupDocumentId` bigint(20) NOT NULL,
  `inspectionDate` date DEFAULT NULL,
  `whetherElectronic` tinyint(1) DEFAULT NULL,
  `whetherInspectionDone` tinyint(1) DEFAULT NULL,
  `whetherInspectionRequired` tinyint(1) DEFAULT NULL,
  `whetherReturnable` tinyint(1) DEFAULT NULL,
  `modeOfReturn` varchar(255) DEFAULT NULL,
  `modeOfSubmission` varchar(255) DEFAULT NULL,
  `returnedDate` datetime DEFAULT NULL,
  `returnedToName` varchar(255) DEFAULT NULL,
  `validTillDate` datetime DEFAULT NULL,
  `inspectionDoneBy` bigint(20) DEFAULT NULL,
  `responsibleUserId` bigint(20) DEFAULT NULL,
  `returnedBy` bigint(20) DEFAULT NULL,
  `returnedToUserId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'PASS/FAIL',
  PRIMARY KEY (`id`),
  KEY `Refadmission878_idx` (`admissionId`),
  KEY `Refevaldocument43_idx` (`evaluationGroupDocumentId`),
  KEY `RefinspectionDoneBy_idx` (`inspectionDoneBy`),
  KEY `RefresponsibleUserId_idx` (`responsibleUserId`),
  KEY `RefreturnedBy_idx` (`returnedBy`),
  KEY `RefreturnedToUserId_idx` (`returnedToUserId`),
  KEY `Refupdateby8787_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refupdateby8787` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refadmission878` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refevaldocument43` FOREIGN KEY (`evaluationGroupDocumentId`) REFERENCES `evaluation_group_document` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefinspectionDoneBy` FOREIGN KEY (`inspectionDoneBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefresponsibleUserId` FOREIGN KEY (`responsibleUserId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefreturnedBy` FOREIGN KEY (`returnedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefreturnedToUserId` FOREIGN KEY (`returnedToUserId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

set foreign_key_checks=1;

