ALTER TABLE `student_program_attendance` 
ADD COLUMN `readByDashboard` BIT(1) NOT NULL DEFAULT 0 AFTER `facultyId`;
ALTER TABLE `student_program_attendance` 
ADD COLUMN `updatedAfterRead` BIT(1) NOT NULL DEFAULT 0 AFTER `readByDashboard`;


ALTER TABLE `student_program_attendance_details` 
ADD COLUMN `readByDashboard` BIT(1) NOT NULL DEFAULT 0 AFTER `attendanceStatus`;
ALTER TABLE `student_program_attendance_details` 
ADD COLUMN `updateAfterRead` BIT(1) NULL DEFAULT 0 AFTER `lastUpdate`;
ALTER TABLE `student_program_attendance_details` 
CHANGE COLUMN `updateAfterRead` `updateAfterRead` BIT(1) NULL DEFAULT b'0' AFTER `readByDashboard`;


ALTER TABLE `student_course_attendance` 
ADD COLUMN `readByDashboard` BIT(1) NOT NULL DEFAULT 0 AFTER `facultyId`,
ADD COLUMN `updatedAfterRead` BIT(1) NOT NULL DEFAULT 0 AFTER `readByDashboard`;


ALTER TABLE `student_course_attendance_details` 
ADD COLUMN `readByDashboard` BIT(1) NOT NULL DEFAULT 0 AFTER `lastUpdate`,
ADD COLUMN `updatedAfterRead` BIT(1) NOT NULL DEFAULT 0 AFTER `readByDashboard`;
ALTER TABLE `student_course_attendance_details` 
CHANGE COLUMN `readByDashboard` `readByDashboard` BIT(1) NOT NULL DEFAULT b'0' AFTER `attendanceStatus`,
CHANGE COLUMN `updatedAfterRead` `updatedAfterRead` BIT(1) NOT NULL DEFAULT b'0' AFTER `readByDashboard`;


ALTER TABLE `faculty_program_attendance` 
ADD COLUMN `readByDashboard` BIT(1) NOT NULL DEFAULT 0 AFTER `attendanceStatus`,
ADD COLUMN `updatedAfterRead` BIT(1) NOT NULL DEFAULT 0 AFTER `readByDashboard`;


ALTER TABLE `faculty_course_attendance` 
ADD COLUMN `readByDashboard` BIT(1) NOT NULL DEFAULT 0 AFTER `toTime`,
ADD COLUMN `updatedAfterRead` BIT(1) NOT NULL DEFAULT 0 AFTER `readByDashboard`;


ALTER TABLE `faculty_course_attendance_details` 
ADD COLUMN `readByDashboard` BIT(1) NOT NULL DEFAULT 0 AFTER `attendanceStatus`,
ADD COLUMN `updatedAfterRead` BIT(1) NOT NULL DEFAULT 0 AFTER `readByDashboard`;


DROP TABLE IF EXISTS `faculty_attendance_dashboard_faculty_wise`;
CREATE TABLE `faculty_attendance_dashboard_faculty_wise` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `facultyId` bigint(20) NOT NULL,
  `totalRecords` bigint(20) NOT NULL,
  `presentRecords` bigint(20) NOT NULL,
  `absentRecords` bigint(20) NOT NULL,
  `presentPercentage` int(3) NOT NULL,
  `absentPercentage` int(3) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `faculty_attendance_dashboard_faculty_wise_1` (`academyLocationId`),
  KEY `faculty_attendance_dashboard_faculty_wise_2` (`facultyId`),
  KEY `faculty_attendance_dashboard_faculty_wise_3` (`lastUpdatedBy`),
  CONSTRAINT `faculty_attendance_dashboard_faculty_wise_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `faculty_attendance_dashboard_faculty_wise_2` FOREIGN KEY (`facultyId`) REFERENCES `staffs` (`userId`),
  CONSTRAINT `faculty_attendance_dashboard_faculty_wise_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


DROP TABLE IF EXISTS `student_attendance_dashboard_student_wise`;
CREATE TABLE `student_attendance_dashboard_student_wise` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `totalRecords` bigint(20) NOT NULL,
  `presentRecords` bigint(20) NOT NULL,
  `absentRecords` bigint(20) NOT NULL,
  `absentPercentage` int(3) NOT NULL,
  `presentPercentage` int(3) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_attendance_dashboard_student_wise_1_idx` (`academyLocationId`),
  KEY `fk_attendance_dashboard_student_wise_5_idx` (`sectionId`),
  KEY `fk_attendance_dashboard_student_wise_6_idx` (`admissionId`),
  KEY `fk_attendance_dashboard_student_wise_7_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_5` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_6` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_attendance_dashboard_student_wise_7` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


DROP TABLE IF EXISTS `student_attendance_dashboard_section_wise`;
CREATE TABLE `student_attendance_dashboard_section_wise` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `componentId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `date` date NOT NULL,
  `totalRecords` bigint(20) DEFAULT NULL,
  `presentRecords` bigint(20) DEFAULT NULL,
  `absentRecords` bigint(20) DEFAULT NULL,
  `absentPercentage` int(3) DEFAULT NULL,
  `presentPercentage` int(3) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_attendance_dashboard_section_wise_1_idx` (`academyLocationId`),
  KEY `fk_attendance_dashboard_section_wise_5_idx` (`sectionId`),
  KEY `fk_attendance_dashboard_section_wise_6_idx` (`courseId`),
  KEY `fk_attendance_dashboard_section_wise_7_idx` (`componentId`),
  KEY `fk_attendance_dashboard_section_wise_8_idx` (`lastUpdatedBy`),
  KEY `fk_student_attendance_dashboard_section_wise_9_idx` (`courseVariantId`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_5` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_6` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_7` FOREIGN KEY (`componentId`) REFERENCES `course_components` (`id`),
  CONSTRAINT `fk_attendance_dashboard_section_wise_8` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_student_attendance_dashboard_section_wise_9` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`)
);


DROP TABLE IF EXISTS `faculty_attendance_dashboard_date_wise`;
CREATE TABLE `faculty_attendance_dashboard_date_wise` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `dateOfAttendance` date NOT NULL,
  `presentRecords` bigint(20) NOT NULL,
  `absentRecords` bigint(20) NOT NULL,
  `totalRecords` bigint(20) NOT NULL,
  `presentPercentage` int(3) NOT NULL,
  `absentPercentage` int(3) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_faculty_attendance_dashboard_date_wise_1_idx` (`lastUpdatedBy`),
  KEY `fk_faculty_attendance_dashboard_date_wise_2_idx` (`academyLocationId`),
  CONSTRAINT `fk_faculty_attendance_dashboard_date_wise_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_faculty_attendance_dashboard_date_wise_2` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`)
);


DROP VIEW IF EXISTS `student_attendance_dashboard_section_wise_section`;
CREATE VIEW `student_attendance_dashboard_section_wise_section` AS
    select 
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `sections`.`sectionCode` AS `sectionCode`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`
    from
        ((((`student_attendance_dashboard_section_wise`
        left join `sections` ON ((`student_attendance_dashboard_section_wise`.`sectionId` = `sections`.`id`)))
        left join `prog_batch_period_config` ON ((`sections`.`periodId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
    where
        (`sections`.`periodId` is not null)
    group by `student_attendance_dashboard_section_wise`.`sectionId`;

    
DROP VIEW IF EXISTS `student_attendance_dashboard_section_wise_variant`;
CREATE VIEW `student_attendance_dashboard_section_wise_variant` AS
    select 
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_section_wise`.`courseId` AS `courseId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `student_attendance_dashboard_section_wise`.`courseVariantId` AS `courseVariantId`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`
    from
        `student_attendance_dashboard_section_wise`
    where
        (`student_attendance_dashboard_section_wise`.`courseVariantId` is not null)
    group by `student_attendance_dashboard_section_wise`.`courseVariantId`;
    

DROP VIEW IF EXISTS `student_attendance_dashboard_student_wise_student`;
CREATE VIEW `student_attendance_dashboard_student_wise_student` AS
    select 
        `student_attendance_dashboard_student_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_student_wise`.`admissionId` AS `admissionId`,
        sum(`student_attendance_dashboard_student_wise`.`presentRecords`) AS `presentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`absentRecords`) AS `absentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`totalRecords`) AS `totalReocrds`,
        round(((sum(`student_attendance_dashboard_student_wise`.`presentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `presentPercentage`,
        round(((sum(`student_attendance_dashboard_student_wise`.`absentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `absentPercentage`
    from
        `student_attendance_dashboard_student_wise`
    group by `student_attendance_dashboard_student_wise`.`admissionId`;
    
