CREATE TABLE `evaluation_type` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `evaluationType` VARCHAR(60) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_evaltype_users_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_evaltype_users`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);


CREATE TABLE `evaluation_sub_type` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `evaluationSubType` VARCHAR(60) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_evalsubtype_users_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_evalsubtype_users`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
