SET FOREIGN_KEY_CHECKS=0;
DROP TABLE If EXISTS `course_hw_asignment`;
DROP TABLE If EXISTS `assignment`;
DROP TABLE If EXISTS `assignment_topics`;
DROP TABLE If EXISTS `course_hw_topics`;
DROP TABLE If EXISTS `course_hw_documents`;
DROP TABLE If EXISTS `group_hw_assignment`;
DROP TABLE If EXISTS `individual_hw_assignment`;
DROP TABLE If EXISTS `individual_hw_download`;
DROP TABLE If EXISTS `individual_hw_upload`;
SET FOREIGN_KEY_CHECKS=1;

CREATE TABLE `course_hw_asignment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assignmentName` varchar(255) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `topicType` varchar(45) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `evaluationSequenceId` bigint(20) DEFAULT NULL,
  `evaluationDetailSequenceId` bigint(20) DEFAULT NULL,
  `dateGiven` date NOT NULL,
  `dateSubmitted` date DEFAULT NULL,
  `hwOnlineSubmissions` bit(1) DEFAULT NULL,
  `dateResubmitted` date DEFAULT NULL,
  `submissionDate` date DEFAULT NULL,
  `hWRemarks` varchar(255) DEFAULT NULL,
  `distributionModeId` bigint(20) DEFAULT NULL,
  `whetherMarkGrade` varchar(45) DEFAULT NULL,
  `marks` int(11) DEFAULT NULL,
  `grades` varchar(4) DEFAULT NULL,
  `assignmentType` varchar(2) DEFAULT NULL,
  `hWOnlineSubmissionGroup` char(1) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refprog_batch_period_config200` (`programBatchPeriodConfigId`),
  KEY `Refevaluation_plan847` (`evaluationPlanId`),
  KEY `Refevaluation_group848` (`evaluationGroupId`),
  KEY `Refevaluation_sequence849` (`evaluationSequenceId`),
  KEY `Refeval_seq_detail850` (`evaluationDetailSequenceId`),
  KEY `Refsections851` (`sectionId`),
  KEY `Refusers1248` (`lastUpdatedBy`),
  KEY `RefcourseVariant1001_idx` (`courseVariantId`),
  KEY `Reffaculty1005_idx` (`facultyId`),
  KEY `Refdistributionmode1008_idx` (`distributionModeId`),
  CONSTRAINT `RefcourseVariant1001` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refdistributionmode1008` FOREIGN KEY (`distributionModeId`) REFERENCES `distribution_mode` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refevaluation_group848` FOREIGN KEY (`evaluationGroupId`) REFERENCES `evaluation_group` (`id`),
  CONSTRAINT `Refevaluation_plan847` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `Refevaluation_sequence849` FOREIGN KEY (`evaluationSequenceId`) REFERENCES `evaluation_sequence` (`id`),
  CONSTRAINT `Refeval_seq_detail850` FOREIGN KEY (`evaluationDetailSequenceId`) REFERENCES `eval_seq_detail` (`id`),
  CONSTRAINT `Reffaculty1005` FOREIGN KEY (`facultyId`) REFERENCES `faculties` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refprog_batch_period_config200` FOREIGN KEY (`programBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `Refsections851` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `Refusers1248` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;


CREATE TABLE `course_hw_topics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hwAssignmentId` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refcourse_hw_asignment5898_idx` (`hwAssignmentId`),
  KEY `Refcoursetopics2937_idx` (`courseTopicId`),
  KEY `Refusers4007_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refcourse_hw_asignment5898` FOREIGN KEY (`hwAssignmentId`) REFERENCES `course_hw_asignment` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcoursetopics2937` FOREIGN KEY (`courseTopicId`) REFERENCES `course_topics` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers4007` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `course_hw_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hwAssignmentId` bigint(20) DEFAULT NULL,
  `hwFile` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refhomework1001_idx` (`hwAssignmentId`),
  KEY `Refusers23223_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refhomework1001` FOREIGN KEY (`hwAssignmentId`) REFERENCES `course_hw_asignment` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers23223` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `group_hw_assignment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hwAssignmentId` bigint(20) DEFAULT NULL,
  `personId` decimal(10,0) NOT NULL,
  `studentId` bigint(20) NOT NULL,
  `groupName` varchar(255) DEFAULT NULL,
  `whetherGroupLeader` bit(1) DEFAULT NULL,
  `submissionStatus` varchar(45) DEFAULT NULL,
  `submissionDate` date DEFAULT NULL,
  `resubmissionDate` date DEFAULT NULL,
  `markObtained` int(4) DEFAULT NULL,
  `gradeObtained` varchar(45) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `markesGrade` varchar(3) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refcourse_hw_asignment1861` (`hwAssignmentId`),
  KEY `Refstudents2133` (`studentId`),
  KEY `Refusers1345` (`lastUpdatedBy`),
  CONSTRAINT `Refcourse_hw_asignment1861` FOREIGN KEY (`hwAssignmentId`) REFERENCES `course_hw_asignment` (`id`),
  CONSTRAINT `Refstudents2133` FOREIGN KEY (`studentId`) REFERENCES `students` (`personId`),
  CONSTRAINT `Refusers1345` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

