CREATE OR REPLACE
   
VIEW `fee_dashboard_outstanding_userwise_student_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`bill_header`.`billStatus` in ('SETTLED' , 'PARTLY_SETTLED', 'FULLY_PENDING'))
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')));
