-- make a column unique in enq_negative_list
ALTER TABLE `enq_negative_list` 
ADD UNIQUE INDEX `primaryeEmailId_UNIQUE` (`primaryeEmailId` ASC),
ADD UNIQUE INDEX `cellNo_UNIQUE` (`cellNo` ASC),
ADD UNIQUE INDEX `phoneNo_UNIQUE` (`phoneNo` ASC);

-- standard master entry for enq_negative_list
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master(`id`, `tableName`, `masterName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'enq_negative_list', 'ENQ_NEGATIVE_LIST', 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`,  
  `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
  `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'phoneNo', 'PHONE_NO', @standardMasterMaxId + 1, 'varchar', '1', 0, NULL, NULL, NULL, 0, 0, 0, '1', SYSDATE());


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`,  
  `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
  `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'cellNo', 'CELL_NO', @standardMasterMaxId + 1, 'Number', '2', 0, NULL, NULL, NULL, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`,  
  `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
  `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'primaryeEmailId', 'EMAIL', @standardMasterMaxId + 1, 'varchar', '3', 0, NULL, NULL, NULL, 0, 0, 0, '1', SYSDATE());