
DELIMITER $$

CREATE PROCEDURE truncateauditdB () 
BEGIN

DECLARE tablename VARCHAR(60);
DECLARE dynamicquery VARCHAR(60);
DECLARE end_of_tables INT DEFAULT 0;  

DECLARE listoftables CURSOR FOR 
SELECT t.table_name                                                                                                                                                 
            FROM information_schema.tables t                                                                                                                                    
            WHERE t.table_schema = DATABASE() AND t.table_type='BASE TABLE'
            AND t.table_name <> 'schema_version';
            
DECLARE CONTINUE HANDLER FOR NOT FOUND SET end_of_tables = 1; 

CREATE TEMPORARY TABLE IF NOT EXISTS templog (msg VARCHAR(255)) ENGINE = MEMORY;

OPEN listoftables;
start_loop: LOOP
        FETCH listoftables INTO tablename;

        IF end_of_tables = 1 THEN                                                                                                                                           
                LEAVE start_loop;                                                                                                                                              
        END IF; 

        SET @dynamicquery = CONCAT('TRUNCATE TABLE ',tablename );

        INSERT INTO templog VALUES(@dynamicquery);

        PREPARE queryexecution FROM @dynamicquery;
        EXECUTE queryexecution;
        DEALLOCATE PREPARE queryexecution;
        COMMIT;
END LOOP;
CLOSE listoftables;
    
END$$
DELIMITER ;

  
SET @OLD_SQL_SAFE_UPDATES = @@SQL_SAFE_UPDATES;
SET SQL_SAFE_UPDATES =0;

SET @OLD_FOREIGN_KEY_CHECKS = @@FOREIGN_KEY_CHECKS;
SET FOREIGN_KEY_CHECKS =0;

CALL truncateauditdB();

SET SQL_SAFE_UPDATES = @OLD_SQL_SAFE_UPDATES;
SET FOREIGN_KEY_CHECKS = @OLD_FOREIGN_KEY_CHECKS;
