
DELIMITER $$

DROP PROCEDURE IF EXISTS V20200825203915__AlterDataGridConfigaudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200825203915__AlterDataGridConfigaudit()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='data_grid_user_override_history' 
  AND column_name='applicantId')) THEN
  
  ALTER TABLE `data_grid_user_override_history`
  DROP COLUMN `applicantId`;
  
  END IF;	
  
  
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='data_grid_user_override_history' 
		  AND column_name='externalUserId')) THEN
  
		  ALTER TABLE  `data_grid_user_override_history`
		  ADD COLUMN `externalUserId` BIGINT NULL DEFAULT NULL AFTER `userId`;
		  
		  END IF;
  

END $$

-- Execute the stored procedure
CALL V20200825203915__AlterDataGridConfigaudit $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200825203915__AlterDataGridConfigaudit $$
 
DELIMITER ;