DELIMITER $$
DROP PROCEDURE IF EXISTS V20221209190104__Create_SunFlagAudit $$
CREATE PROCEDURE V20221209190104__Create_SunFlagAudit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='flag_history')) THEN 
CREATE TABLE flag_history (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `REV` int NOT NULL,
  `REVTYPE` tinyint DEFAULT NULL,
  `flagCode` VARCHAR(255) NOT NULL,
  `flagName` VARCHAR(100) NOT NULL,
  `flagStatus` BIT NOT NULL DEFAULT b'0',
  `flagCordinatorId` BIGINT NOT NULL,
  `businessRuleId` BIGINT NULL DEFAULT NULL,
  `startDate` DATE NULL DEFAULT NULL,
  `endDate` DATE NULL DEFAULT NULL,
  `isInitiated` BIT NOT NULL DEFAULT b'0',
  `approveStatus` BIT NOT NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20221209190104__Create_SunFlagAudit () $$ 
DROP PROCEDURE IF EXISTS V20221209190104__Create_SunFlagAudit $$ 
DELIMITER ;