DELIMITER $$
DROP PROCEDURE IF EXISTS V20230908182827__Create_SalesForceStudentProgramAudit $$
CREATE PROCEDURE V20230908182827__Create_SalesForceStudentProgramAudit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='salesforce_student_program_history')) THEN 
CREATE TABLE IF NOT EXISTS `salesforce_student_program_history` (
 	`id` BIGINT(20) NOT NULL,
 	`REV` BIGINT(20) NOT NULL,
  	`REVTYPE` tinyint(4) NULL DEFAULT NULL,
  	`personId` BIGINT(20) NOT NULL,
	`applicationId` BIGINT(20) NOT NULL,
    `countryOfRecruitmentId` BIGINT(20) NOT NULL,
    `salesForceApplication` VARCHAR(255) NOT NULL,
    `salesForceStage` VARCHAR(255) NOT NULL,
    `verticalArea` VARCHAR(255) DEFAULT NULL,
    `subProgram1` VARCHAR(255) DEFAULT NULL,
    `subProgram2` VARCHAR(255) DEFAULT NULL,
    `deliveryMode` VARCHAR(255) DEFAULT NULL,
    `articulationAgreementNote` VARCHAR(255) DEFAULT NULL,
    `admissionComments` VARCHAR(255) DEFAULT NULL,
    `scholarshipName` VARCHAR(255) DEFAULT NULL,
    `scholarshipDuration` VARCHAR(255) DEFAULT NULL,
    `isLateArrival` BIT(1) NOT NULL DEFAULT b'0',
    `isDirectEntry` BIT(1) NOT NULL DEFAULT b'0',
    `isTransferCase` BIT(1) NOT NULL DEFAULT b'0',
    `applicantPortalContact` VARCHAR(255) DEFAULT NULL,
    `ecCommissionAccount` VARCHAR(255) DEFAULT NULL,
    `applicationOwner` VARCHAR(255) DEFAULT NULL,
    `sommetProgramID` VARCHAR(255) NOT NULL,
  	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  	`lastUpdatedBy` BIGINT(20) NOT NULL,
  	PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230908182827__Create_SalesForceStudentProgramAudit () $$ 
DROP PROCEDURE IF EXISTS V20230908182827__Create_SalesForceStudentProgramAudit $$ 
DELIMITER ;