DELIMITER $$
DROP PROCEDURE IF EXISTS V20240923111322__Create_alumniManagementAllAudit $$
CREATE PROCEDURE V20240923111322__Create_alumniManagementAllAudit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_users_history')) THEN	
CREATE TABLE `alumni_users_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `alumniCode` varchar(255) NOT NULL,
  `studentCode` varchar(255) DEFAULT NULL,
  `admissionCode` varchar(255) DEFAULT NULL,
  `emailId` varchar(255) NOT NULL,
  `createdDate` datetime(6) NOT NULL,
  `password` varchar(255) NOT NULL,
  `encrypt` varchar(255) NOT NULL,
  `passwordResetRequired` bit(1) NOT NULL,
  `resetPassword` varchar(255) DEFAULT NULL,
  `failedLoginAttempts` int DEFAULT NULL,
  `accountLocked` bit(1) DEFAULT NULL,
  `lockExpiration` datetime(6) DEFAULT NULL,
  `whetherActive` bit(1) NOT NULL DEFAULT TRUE,
  `whetherDeleted` bit(1) NOT NULL DEFAULT FALSE,
  `messageAction` enum('NEW_USER_CREATION','RESET_PASSWORD') NOT NULL DEFAULT 'NEW_USER_CREATION',
  `messageStatus` enum('FAILURE','PENDING','SUCCESS') NOT NULL DEFAULT 'PENDING',
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;	

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_persons_history')) THEN	
CREATE TABLE `alumni_persons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `signupCode` varchar(255) DEFAULT NULL,
  `salutationId` bigint DEFAULT NULL,
  `firstName` varchar(255) NOT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) NOT NULL,
  `gender` enum('FEMALE','MALE','OTHER') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `emailId` varchar(255) NOT NULL,
  `phoneCountryCode` varchar(255) DEFAULT NULL,
  `mobileNumber` varchar(255) NOT NULL,
  `documentURL` varchar(255) DEFAULT NULL,
  `imageURL` varchar(255) DEFAULT NULL,
  `passoutYear` int DEFAULT NULL,
  `admissionCode` varchar(255) DEFAULT NULL,
  `studentCode` varchar(255) DEFAULT NULL,
  `alumniUserId` bigint DEFAULT NULL,
  `academyLocationId` bigint NOT NULL,
  `programId` bigint DEFAULT NULL,
  `otherProgramName` varchar(255) DEFAULT NULL,
  `batchId` bigint DEFAULT NULL,
  `otherBatchName` varchar(255) DEFAULT NULL,
  `status` enum('APPROVED','REJECTED','PENDING') DEFAULT 'PENDING',
  `reason` TEXT DEFAULT NULL,
  `personMessageAction` enum('APPROVED','REJECT') NOT NULL DEFAULT 'APPROVED',
  `messageStatus` enum('FAILURE','PENDING','SUCCESS') NOT NULL DEFAULT 'PENDING',
  `whetherDeleted` bit(1) NOT NULL DEFAULT FALSE,
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;	

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_funds_history')) THEN
CREATE TABLE `alumni_funds_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `fundsCode` varchar(255) NOT NULL,
  `fundsTitle` varchar(255) NOT NULL,
  `currencyId` bigint NOT NULL,
  `donationGoal` bigint NOT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `imageUrl` varchar(255) DEFAULT NULL,
  `status` bit(1) NOT NULL DEFAULT b'1',
  `description` varchar(512) DEFAULT NULL,
   whetherDeleted BOOLEAN NOT NULL DEFAULT false,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_donation_range_history')) THEN 
CREATE TABLE `alumni_donation_range_history` (
   id BIGINT NOT NULL, 
   REV bigint NOT NULL,
   REVTYPE tinyint DEFAULT NULL,
  `alumniFundsId` bigint NOT NULL,
  `minimumValue` double NOT NULL,
  `maximumValue` double NOT NULL,
  `lastUpdatedBy` BIGINT NULL default NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_funds_academy_location_mapping_history')) THEN
CREATE TABLE `alumni_funds_academy_location_mapping_history` (
   id BIGINT NOT NULL, 
   REV bigint NOT NULL,
   REVTYPE tinyint DEFAULT NULL,
  `alumniFundsId` bigint NOT NULL,
  `academyLocationId` bigint NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_payment_history')) THEN
CREATE TABLE `alumni_payment_history` (
   id BIGINT NOT NULL, 
   REV bigint NOT NULL,
   REVTYPE tinyint DEFAULT NULL,
  `alumniUserId` bigint NOT NULL,
  `alumniFundsId` bigint NOT NULL,
  `currencyId` bigint NOT NULL,
  `amount` double NOT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `paymentGateway` varchar(255) DEFAULT NULL,
  `transactionId` varchar(255) DEFAULT NULL,
  `paymentStatus` enum('CANCELLED','FAILED','PENDING','SUCCESS','TXN_SUCCESS') NOT NULL DEFAULT 'PENDING',
  `receiptCode` varchar(255) DEFAULT NULL,
  `receiptPath` varchar(255) DEFAULT NULL,
  `alumniDonationRangeId` BIGINT(20) DEFAULT NULL,
   PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_professional_information_history')) THEN
CREATE TABLE alumni_professional_information_history (
    id BIGINT NOT NULL, 
    REV bigint NOT NULL,
    REVTYPE tinyint DEFAULT NULL,
    occupation VARCHAR(255) DEFAULT NULL,
    organization VARCHAR(255) DEFAULT NULL,
    designation VARCHAR(255) DEFAULT NULL,
    officialEmailId VARCHAR(255) DEFAULT NULL,
    phoneCountryCode VARCHAR(20) DEFAULT NULL,
    officialContactNumber VARCHAR(50) DEFAULT NULL,
    officialWebsiteLink VARCHAR(255) DEFAULT NULL,
    linkedInLink VARCHAR(255) DEFAULT NULL,
    twitterLink VARCHAR(255) DEFAULT NULL,
    about TEXT DEFAULT NULL,
    alumniPersonId BIGINT NOT NULL,
	lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_address_history')) THEN 
CREATE TABLE `alumni_address_history` (
    id BIGINT NOT NULL, 
    REV bigint NOT NULL,
    REVTYPE tinyint DEFAULT NULL,
    alumniPersonId BIGINT DEFAULT NULL,
    addressType enum('PERSONAL','PROFESSIONAL','OTHER') DEFAULT NULL,
    isPrimary BOOLEAN DEFAULT FALSE,
    isCommunicationAddress BOOLEAN DEFAULT FALSE,
    isLegalAddress BOOLEAN DEFAULT FALSE,
    addressLine1 VARCHAR(255) DEFAULT NULL,
    addressLine2 VARCHAR(255) DEFAULT NULL,
    cityId BIGINT DEFAULT NULL,
    latitude VARCHAR(255) DEFAULT NULL,
    longitude VARCHAR(255) DEFAULT NULL,
    postalCode VARCHAR(255) DEFAULT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_setup_history')) THEN 
CREATE  TABLE alumni_portal_setup_history (
    id BIGINT NOT NULL, 
    REV bigint NOT NULL,
    REVTYPE tinyint DEFAULT NULL,
    setupname VARCHAR(255) DEFAULT NULL,
    createdby BIGINT(20),
    createddate DATE,
    mappingstatus BOOLEAN DEFAULT false,
    status BOOLEAN DEFAULT false,
    createdfromalid BIGINT(30) NOT NULL,
    whetherDeleted boolean DEFAULT false,
    lastUpdate DATE,
    lastUpdatedBy BIGINT(20),
   PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_modules_history')) THEN 
CREATE TABLE alumni_portal_modules_history (
    id bigint NOT NULL,
	REV int(11) NOT NULL,
	REVTYPE tinyint(4) DEFAULT NULL,
    module_name VARCHAR(255) DEFAULT NULL,
	module_code VARCHAR(255) DEFAULT NULL,
	form_alias_name VARCHAR(255) DEFAULT NULL,
	tableName VARCHAR(255) DEFAULT NULL,
    lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
	PRIMARY KEY (id,REV)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_modules_setup_history')) THEN 
CREATE  TABLE alumni_portal_modules_setup_history (
	id bigint(20) NOT NULL,
	REV int(11) NOT NULL,
	REVTYPE tinyint(4) DEFAULT NULL,
	module_name_id BIGINT(20) DEFAULT NULL,
    visibility BOOLEAN DEFAULT FALSE,
    mandatory BOOLEAN DEFAULT FALSE,
    sequenceNo INTEGER,
    new_module_name VARCHAR(255),
	setup_id BIGINT(20),
    lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
	PRIMARY KEY (id,REV)
	);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_applyTo_history')) THEN 
CREATE  TABLE alumni_portal_applyTo_history (
 `id` bigint(20) NOT NULL,
REV int(11) NOT NULL,
REVTYPE tinyint(4) DEFAULT NULL,
alumni_portal_setup_id BIGINT(20) DEFAULT NULL,
academy_locations_id BIGINT(20) DEFAULT NULL,
whetherDeleted BOOLEAN DEFAULT NULL,
lastUpdate TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
lastUpdatedBy BIGINT(20),
PRIMARY KEY (`id`,`REV`)
);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_news_and_feeds_history')) THEN
CREATE TABLE `alumni_news_and_feeds_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) DEFAULT NULL,
  `code` VARCHAR(255) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `startDate` DATE DEFAULT NULL,
  `startTime` TIME DEFAULT NULL,
  `endDate` DATE DEFAULT NULL,
  `endTime` TIME DEFAULT NULL,
  `description` TEXT DEFAULT NULL,
  `imageUrl` VARCHAR(255) DEFAULT NULL,
  `status` ENUM('PUBLISHED','UNPUBLISHED') DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `whetherDeleted` BOOLEAN NOT NULL DEFAULT FALSE,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_news_and_feeds_mapping_history')) THEN
CREATE TABLE `alumni_news_and_feeds_mapping_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) DEFAULT NULL,
  `alumniNewsAndFeedsId` BIGINT DEFAULT NULL,
  `academyLocationId` BIGINT DEFAULT NULL,
  `programId` BIGINT DEFAULT NULL,
  `batchId` BIGINT DEFAULT NULL,
  `passoutYear` INT DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=INNODB;
END IF;

IF NOT EXISTS (SELECT * 
                   FROM information_schema.tables 
                   WHERE table_schema = DATABASE() 
                   AND table_name = 'alumni_user_news_feeds_restriction_history') THEN
        CREATE TABLE `alumni_user_news_feeds_restriction_history` (
            `id` bigint(20) NOT NULL,
            `REV` int(11) NOT NULL,
            `REVTYPE` tinyint(4) DEFAULT NULL,
            `alumniUserId` bigint DEFAULT NULL,
            `alumniNewsAndFeedsMappingId` bigint DEFAULT NULL,
            `lastUpdatedBy` bigint DEFAULT NULL,
            `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`, `REV`)
        ) ENGINE=InnoDB;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'alumni_committee_history') THEN
CREATE TABLE `alumni_committee_history` (
    id BIGINT NOT NULL, 
    REV bigint NOT NULL,
    REVTYPE tinyint DEFAULT NULL,
    committeeCode VARCHAR(255) DEFAULT NULL,
    committeeName VARCHAR(255) DEFAULT NULL,
    committeeCoordinator BIGINT NOT NULL,
    validFromDate DATE DEFAULT NULL,
    validTillDate DATE DEFAULT NULL,
    status BOOLEAN DEFAULT FALSE,
    description TEXT DEFAULT NULL,
    academyLocationId BIGINT NOT NULL,
    committeeTypeId BIGINT NOT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
 END IF;
 
 
IF NOT EXISTS (SELECT * FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'alumni_committee_participant_history') THEN 
CREATE TABLE `alumni_committee_participant_history` (
    id BIGINT NOT NULL, 
    REV bigint NOT NULL,
    REVTYPE tinyint DEFAULT NULL,
    alumniCommitteeId BIGINT NOT NULL,
	participantId BIGINT DEFAULT NULL,
    alumniParticipantId BIGINT DEFAULT NULL,
    status enum('JOINED','AVAILABLE') DEFAULT 'AVAILABLE',
	fromDate DATE DEFAULT NULL,
	toDate  DATE DEFAULT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB DEFAULT  CHARSET=utf8; 
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'alumni_committee_academy_location_history') THEN 
CREATE TABLE `alumni_committee_academy_location_history` (
    id BIGINT NOT NULL, 
    REV bigint NOT NULL,
    REVTYPE tinyint DEFAULT NULL,
   alumniCommitteeId BIGINT NOT NULL,
    academyLocationId BIGINT DEFAULT NULL,
	programId BIGINT DEFAULT NULL,
	batchId BIGINT DEFAULT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`,`REV`))
  ENGINE=INNODB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='resource_booking_alumni_users_history')) THEN 
CREATE TABLE resource_booking_alumni_users_history (
    id BIGINT NOT NULL,
	REV bigint(20) NOT NULL,
    REVTYPE tinyint(4) NOT NULL,
    alumniUserId BIGINT DEFAULT NULL,
    resourceBookingId BIGINT DEFAULT NULL,
    isRegistered BOOLEAN DEFAULT FALSE,
    messageStatus enum('SUCCESS','FAILURE','PENDING') DEFAULT 'PENDING',
    eventMessageAction enum('EVENT_CREATION','EVENT_REGISTRATION') DEFAULT NULL,
    lastUpdatedBy bigint DEFAULT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id, REV)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='resource_bookings_history' and column_name='isCheckAlumni')) THEN
ALTER TABLE resource_bookings_history
ADD COLUMN isCheckAlumni BOOLEAN DEFAULT FALSE;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='alumni_gallery_batch_mapping_history')) THEN 
CREATE TABLE alumni_gallery_batch_mapping_history (
    id BIGINT NOT NULL,
	REV bigint(20) NOT NULL,
    REVTYPE tinyint(4) DEFAULT NULL,
    galleryId BIGINT DEFAULT NULL,
    batchId BIGINT DEFAULT NULL,
    programId BIGINT DEFAULT NULL,
    academyLocationId BIGINT DEFAULT NULL,
    isSharedWithAlumni BIT(1) DEFAULT false,
    messageStatus enum('SUCCESS','FAILURE','PENDING') DEFAULT 'PENDING',
    galleryCreationAction enum('GALLERY_CREATION') DEFAULT 'GALLERY_CREATION',
    lastUpdatedBy bigint DEFAULT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id, REV)
);

END IF;

IF NOT EXISTS (SELECT * 
                   FROM information_schema.tables 
                   WHERE table_schema = DATABASE() 
                   AND table_name = 'alumni_notification_history') THEN
        CREATE TABLE `alumni_notification_history` (
            `id` bigint(20) NOT NULL,
            `REV` int(11) NOT NULL,
            `REVTYPE` tinyint(4) DEFAULT NULL,
            `title` varchar(255) DEFAULT NULL,
            `description` varchar(255) DEFAULT NULL,
            `alumniUserId` bigint DEFAULT NULL,
            `createdDate` datetime(6) DEFAULT NULL, 
            `isReadNotification` boolean DEFAULT false, 
            `notificationType` enum('RESET_PASSWORD','FORGET_PASSWORD','NEWS_AND_FEEDS','DONATION','EVENTS','GALLERY') DEFAULT NULL, 
            `lastUpdatedBy` bigint DEFAULT NULL,
            `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`, `REV`)
        ) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='form_field_display_settings_history' AND column_name='alumniportalsetupid')) THEN 
ALTER TABLE `form_field_display_settings_history` 
ADD COLUMN `alumniportalsetupid` BIGINT(20) NULL ;
END IF;


END $$
CALL V20240923111322__Create_alumniManagementAllAudit () $$ 
DROP PROCEDURE IF EXISTS V20240923111322__Create_alumniManagementAllAudit $$ 
DELIMITER ;