DELIMITER $$
DROP PROCEDURE IF EXISTS V20250318152610__Alter_xeroContactHIst $$
CREATE PROCEDURE V20250318152610__Alter_xeroContactHIst()
BEGIN
-- Add columns if they do not exist
IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping_history' 
               AND COLUMN_NAME = 'academiaApplicationId') 
THEN
    ALTER TABLE `xero_user_mapping_history` 
    ADD COLUMN `academiaApplicationId` BIGINT NULL AFTER `academiaUserId`;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_user_mapping_history' 
               AND COLUMN_NAME = 'academiaSponsorId') 
THEN
    ALTER TABLE `xero_user_mapping_history` 
    ADD COLUMN `academiaSponsorId` BIGINT NULL AFTER `academiaApplicationId`;
END IF;

-- Modify column if it exists
IF EXISTS (SELECT * FROM information_schema.COLUMNS 
           WHERE TABLE_SCHEMA = DATABASE() 
           AND TABLE_NAME = 'xero_user_mapping_history' 
           AND COLUMN_NAME = 'academiaUserId') 
THEN
    ALTER TABLE `xero_user_mapping_history` 
    CHANGE COLUMN `academiaUserId` `academiaUserId` BIGINT NULL;
END IF;

END $$
CALL V20250318152610__Alter_xeroContactHIst() $$
DROP PROCEDURE IF EXISTS V20250318152610__Alter_xeroContactHIst $$
DELIMITER ;